# Metadata

CRACMM workflows require that each species in CRACMM has a representative structure specified by a SMILES string. These structures are used to obtain metadata such as solubility (Henry's law coefficients), volatility, and other parameters.

CRACMM3 is the latest version. CRACMM3M includes expanded halogen chemistry. CRACMM3HAPS includes additional hazardous air pollutants. CRACMM2.001 is a minor update to CRACMM2 in which some species names were changed to more closely follow the CRACMM convention that a multiphase species has the same name in both phases.

## Species Information

- All files here are autogenerated by python code from CMAQ files (see the utilities folder). Each mechanism is documented in a markdown and csv file.
  * [CRACMM3](https://github.com/USEPA/CRACMM/tree/main/metadata/cracmm2) metadata: [online table version](cracmm3/cracmm3_species_table.md) and [csv version](cracmm3/cracmm3_metadata.csv)
  * [CRACMM3M](https://github.com/USEPA/CRACMM/tree/main/metadata/cracmm2) metadata: [online table version](cracmm3m/cracmm3m_species_table.md) and [csv version](cracmm3m/cracmm3m_metadata.csv)
  * [CRACMM3HAPS](https://github.com/USEPA/CRACMM/tree/main/metadata/cracmm2) metadata: [online table version](cracmm3haps/cracmm3haps_species_table.md) and [csv version](cracmm3haps/cracmm3haps_metadata.csv)
  * [CRACMM2.001](https://github.com/USEPA/CRACMM/tree/main/metadata/cracmm2) metadata: [online table version](cracmm2.001/cracmm2_species_table.md) and [csv version](cracmm2.001/cracmm2_metadata.csv)
  * [CRACMM2](https://github.com/USEPA/CRACMM/tree/main/metadata/cracmm2) metadata: [online table version](cracmm2/cracmm2_species_table.md) and [csv version](cracmm2/cracmm2_metadata.csv)
  * [CRACMM1](https://github.com/USEPA/CRACMM/tree/main/metadata/cracmm1) metadata: [online table version](cracmm1/cracmm1_aq_species_table.md) and [csv version](cracmm1/cracmm1_aq_metadata.csv)
  * [CRACMM1AMORE](https://github.com/USEPA/CRACMM/tree/main/metadata/cracmm1amore) metadata: [online table version](cracmm1amore/cracmm1amore_aq_species_table.md) and [csv version](cracmm1amore/cracmm1amore_aq_metadata.csv)
- The metadata file in csv is the most complete for describing species and their properties in CMAQ. Properties include:
  * Species name
  * Description
  * Phase (G=gas, P=particle, GP=gas and particle)
  * Stable ("Yes" indicates species with sufficient lifetime to warrant transport in the host model)
  * Molecular weight (g/mol)
  * Representative (compound that best represents the species)
  * SMILES (for representative compound structure)
  * Henry's Law Coefficient for wet removal processes (M/atm)
  * Enthalpy of solvation used to adjust the Henry's Law Coefficient for temperature (K)
  * Density of species in the particulate phase (kg m<sup>-3</sup>)
  * Hygroscopicity parameter, &kappa;, for organic aerosol species (water uptake on inorganic species should be calculated with a thermodynamic model such as E-AIM, ISORROPIA, or similar)
  * Saturation concentration (&mu;g m<sup>-3</sup>)
  * Enthalpy of vaporization used to adjust the saturation concentration for temperature (J/mol)
  * Organic matter to organic carbon ratio for organic aerosol (g/g)
- [Properties of species emitted in CRACMM1](cracmm1/CRACMM1_2017_emiss_properties.csv) based on 2017 U.S. anthropogenic and biomass burning emissions as used by [Pye et al. 2023](https://doi.org/10.5194/acp-23-5043-2023)
