# How to Contribute

Members of the scientific community can contribute to official CRACMM versions. The process to contribute includes:

## CRACMM Scope Discussion (optional)
For developers interested in getting early feedback on whether an update is likely a good fit for CRACMM, they can request an optional initial scope discussion with the CRACMM leads and/or CRACMM development team. Scope discussions may include information on potential duplication or partners for further development and are not decisions regarding approval or disapproval of a particular update. Science scope discussions will be documented on the CMAQ_Dev (eventually CRACMM) GitHub site as issues.
 
## CRACMM Science Proposal Process (required)
Updates to CRACMM must undergo a proposal stage prior to code submission. The CRACMM science proposal process will consist of a one-hour virtual meeting in which the developer presents their update and its suitability for incorporation in the official CRACMM. The developer should include information to discern:

* the complexity of the update (for example: chemical systems considered, number of new species, number of new reactions, model processes needing update, etc), 

* underlying scientific basis (for example: data used for evaluation, simulations performed, impact on priority species, etc), and

* the path to documentation in a peer-reviewed publication.  

The meeting will be open to the entire EPA CRACMM development team with CRACMM leads at EPA and NOAA as mandatory attendees (see the [CRACMM White Paper](https://www.epa.gov/cmaq/cracmm)). The NOAA CRACMM lead may invite additional NOAA scientists. Other critical external scientists involved in the development of an update may also be invited to provide scientific information. Within one month of the proposal meeting, CRACMM lead(s) will synthesize meeting discussion with a goal of determining a consensus and provide feedback to the developer on whether the update is ready to proceed. The CRACMM science proposal discussion outcome and path to integration in the main CRACMM mechanism will be documented in a CMAQ_Dev (eventually CRACMM) GitHub Issue. The science proposal occurs before the Code Pull Request, but the exact timing is up to the developer. 
 
## CRACMM Code Review (required)
All updates to CRACMM must go through the CMAQ Code Pull Request procedure (see the [Developers' Guide](https://github.com/USEPA/CMAQ/blob/main/DOCS/Developers_Guide/CMAQ_Dev_Guide.md) for the Community Multiscale Air Quality (CMAQ) Modeling System). Receiving positive support in a CRACMM Science Proposal meeting does not guarantee incorporation in the official CRACMM.