!*********************************
!***Module for Shared Variables***
!*********************************
	MODULE SHAREDVARS
	INTEGER IGO									!Debug input flag
	LOGICAL PARMESTDONE /.FALSE./						!Flag for parameter estimates completed
	LOGICAL DATACHANGED							!Flag for occurrence of datachange (to trigger clearing old analysis info) 
	LOGICAL PARMCONFDONE /.FALSE./					!Flag for parameter confidence limits completed
	LOGICAL LINECONFDONE /.FALSE./					!Flag for line confidence limits completed
	LOGICAL CURVEFIT /.FALSE./						!Flag for whether analysis supports maximum likelihood curve fit
	LOGICAL DATAPLOTDONE /.FALSE./					!Flag for dataplot successfully done
	LOGICAL PRINTFLAG /.FALSE./
	LOGICAL PRINTFLAG2/.FALSE./
	LOGICAL Y0HIFLAG /.FALSE./
!***
!***Winteracter Routine Variables
!***
	INTEGER RESETERROR							!Integer to receive result when resetting error code
	CHARACTER(LEN=512) STRING						!General message string variable
!***
!***Input/Output String Variables 
!***										
	CHARACTER(LEN=256) OUTFILE						!Output filename (for csv file)
	CHARACTER(LEN=80) HEADERSTRING/'TEST'/				!String for output header/title
	CHARACTER(LEN=60) ERRORMESSAGE(12)					!Vector of error messages to provide on interface
	INTEGER NERROR/0/
!***
!***Variables for plotting data set and other graphing variables
!***
	INTEGER NPLOT								!Number of data in plotting data set
	REAL XPLOT(100)								!Exposure values for plotting data set
	REAL YPLOT(100)								!Fraction survival for plotting data set
	REAL MPLOT(100)								!Initial number of organisms for plotting data set
	INTEGER CPLOT(100)							!Flag for whether data is plotted but not analyzed
	REAL RELASPECT /1.0/							!Relative aspect ratio for output characters
	REAL RELSIZEHEAD /2.0/							!Relative size for title/header characters
	REAL RELSIZEAXIS /1.25/							!Relative size for axis label characters
	REAL RELSIZETIC /1.0/							!Relative size for tic label characters
	REAL RELTHICKAXIS /1.0/							!Relative thickness for axis line, tic marks
	REAL RELTHICKPLOT /1.5/							!Relative thickness for effects curve line
	REAL RELSIZESYMB /1.0/							!Relative size for plot symbols
	CHARACTER(LEN=50) XLABEL /'Exposure Value'/			!X axis label
	CHARACTER(LEN=50) YLABEL /'Fraction Survival'/			!Y axis label
	REAL XMINTIC,XMAXTIC							!Minimum and maximum for X axis = Range for line calculations
!***
!***Variables For Analysis Data Set
!***
	INTEGER NDAT								!Number of data points in analysis data set
	REAL*8 XDAT(100)								!Exposure values for analysis data set 
	REAL*8 YDAT(100)								!Number of surviving organisms
	REAL*8 MDAT(100)								!Initial number of organisms
	REAL*8 CONTROLAVG								!Observed average survival in control plateau
	INTEGER XTRANSFORM/1/							!Option for transform of entered eEXPosure values 1=values are raw and log transform them, 2=values are already logarithms, 3=values are raw and leave untransformed
!***
!***Variables at treatment level (if replicates detected)
!***
	INTEGER NTRT								!Number of treatments 
	REAL XTRT(100)								!EEXPosure values for treatments
	REAL YTRT(100)								!Number of surviving organisms for treatment
	REAL YTRTFRAC(100)							!Fractional survival for treatment																					
	REAL MTRT(100)								!Initial Number of Organisms for treatment
	INTEGER NREP(100)								!Number of replicates for treatment
	LOGICAL REPDETECT								!Flag for detecting replicates 
!***
!***Model Analysis Variables
!***
	INTEGER IPHASE								!Flag for analysis phase; 0=param estim, 1=EC confidence limits, 2=line confidence limits 
	CHARACTER(LEN=8) PARMNAME(4,10)/&					!Parameter names for each model option								
		'CtrlVal','logEC50','InvScale',' ',&
		'CtrlVal','logEC50','StdDev',' ',&
		'CtrlVal','logEC50','Range',' ',&
		'CtrlVal','logEC50','Range',' ',&
		'CtrlVal','logEC50','Beta',' ',&
		'CtrlVal','logEC50','Beta',' ',&
		'CtrlVal','logEC50','Lambda',' ',&
		'CtrlVal','logEC50','Range','FracM',&
		'CtrlVal','logEC50','Scale','logKappa',&
		'CtrlVal','logEC50','Scale','logXi'/
	CHARACTER(LEN=4) ECPNAME/'EC10'/					!Name for ECp
	INTEGER MODELOPT/1/							!Model option number
	INTEGER NPARM								!Number of parameters to fit
	INTEGER NPARMMOD(10)/3,3,3,3,3,3,3,4,4,4/				!Number of paameters for each model
	REAL*8 PARMGUESS(4)							!Initial guesses for model parameters
	REAL*8 PARMMIN(4),PARMMAX(4)						!Minimum and maximum allowed parameter values
	REAL*8 PARMSOLUT(4)							!Maximum likelihood parameter solutions (parameter 2 is X50) 
	REAL*8 ECPSOLUT								!Maxlike solution for EXP
	REAL*8 PARMALT(4)								!Alternative parameter values when inadequate data for definitive maximum likelihood 
	REAL*8 ECPALT								!Alternative solution for EXP
	REAL*8 FUNCSOLUT								!Value for -log sum likelihood statistic at maximum likelihood solution
	REAL*8 FUNCALT								!Value for -log sum likelihood statistic for alternative parameter values
	REAL*8 PARMTEMP(4)							!Transient storage for model parameters (for function calls)
	REAL*8 PTARGET(3)/0.5D0,0.1D0,0.5D0/				!Probability for ECp parameter in model in model calculations = 50% for basic parameterization, use opt for ECP (default 10%), 50% for scale parameter UCL calc    
	INTEGER NLINE/100/							!Number of points in predicted line
	REAL XLINE(100),YLINE(100)						!X and Y values for predicted line
	INTEGER NCTRL,NPART,NFULL						!Number of points in (a) control plateau, (b) in treatment range with partial survival, (c) in upper range with no survival
	REAL*8 AIC									!Akaike Information Criterion 
!***
!***Parameter confidence limits Variables
!***
	INTEGER CLOPT								!Option for Cls; 1=EC50, 2=ECP, 3=Scale (UCL only)
	INTEGER FIXPARMCLID,FIXPARMLIMID					!Index of parameter for which CL is being calculated or for which parameter is at min/max 
	INTEGER NOPTPARM								!Reduced NPARM for parameters that are reoptimized during search for confidence limits of FIEXPARM
	INTEGER OPTPARMID(4)							!Indices of parameters being reoptimized when selected parameters are fixed
	REAL*8 FIXPARMCLVAL,FIXPARMLIMVAL					!Value for FIXPARMS while other parameters optimized
	REAL*8 LIKETARGET,LIKESEARCH(3)					!Target value for likelihood statistic at confidence limit
	REAL*8 FIXPARMCLSEARCH(3),FIXPARMINIT,FIXPARMDELTA
	REAL*8 PARMLCL(3),PARMUCL(3)						!Confidence limits for EC50 (index 1) and ECP (index 2) and scale (index 3)
	REAL*8 FUNCLCL(3),FUNCUCL(3)						!Likelihood statistic at confidence limits for EC50 and ECP and scale
	INTEGER CLFLAGLCL(0:4,4),CLFLAGUCL(0:4,4)				!Error flags for EC50 and ECP confidence limit calculations
	REAL*8 OPTPARMATLCL(4,3),OPTPARMATUCL(4,3)			!Parameter values for refitted parameters at EC50 and ECp confidence limits
	REAL*8 CLPARMMIN(4),CLPARMMAX(4)					!Limits for parameters being reoptimized in CL calculations 
!***
!***Line confidence limits variables
!***
	INTEGER FIXLINE								!Index of point on line for which Cl is being calculated 
	REAL*8 FIXLINEVAL								!Value for FIXLINE while other parameters optimized
	REAL LINELCL(100),LINEUCL(100)					!Confidence limits for line
	REAL*8 FUNCLINELCL(100),FUNCLINEUCL(100)				!Likelihood statistic at line confidence limits
	INTEGER CLFLAGLINELCL(100,0:4),CLFLAGLINEUCL(100,0:4)		!Error flags for line confidence limit calculations - 
	REAL*8 OPTPARMATLINELCL(100,4),OPTPARMATLINEUCL(100,4)	!Parameter values for refitted parameters at line confidence limits 
	LOGICAL Y0FLAG/.FALSE./							!Flag for Y0>1.0 during line CL calculations - flag to adjust other parameters being optimized 
	INTEGER Y0FLAGCOUNT(100),FUNCLINECOUNT(100)										 
!***
!***Newton Optimization Routine Variables
!***
	REAL*8 OPTPARMSEARCH(4,0:5)						!Parameter values for search point set
	REAL*8 FUNC(0:5)								!Optimization function values for search point set
	REAL*8 DFUNC(4),DFUNC2(4,4)						!First and second derivatives of optimization function
	REAL*8 DY(4),DY2(4,4)							!First and second derivatives of model value
	REAL*8 MATRIX(4,4)							!Inverse of DFUNC2 - matrix for search algorithm
	REAL*8 VECTOR(4)								!Search vector
	REAL*8 STEP(0:5)								!Step size for search points along vector
	INTEGER BEST								!Index for best point in search point set 
	INTEGER MAXIT /50/							!Maximum iterations
	INTEGER MLINE /20/							!Maximum line search steps
	REAL*8 CONVRGREQ /1D-4/							!Convergence criterion
	INTEGER OPTIMIZERROR(0:8)						!Error codes
	REAL*8 HISTFUNC(0:50),HISTPARM(0:50,4),HISTDFUN(0:50,4)	!Search history variables
	INTEGER HISTITER								!Search history variable
	LOGICAL CONVERGE

	END MODULE SHAREDVARS
