	SUBROUTINE PRINTPARAM(BTOP)
	USE WINTERACTER
	USE SHAREDVARS
	USE RESOURCE
	CHARACTER(LEN=10) HEADING(5) /"ParmName","ParmGuess","ParmMin","ParmMax","MaxLikeEst"/
	REAL BTOP,BHGT,BWID,COLLOC(5)/0.9,2.1,3.3,4.5,5.7/
	INTEGER IPARM,ICOL
!Define Graphics Area and Units for Parameter Grid; OutIPARM Area 
	BHGT=0.55+4*0.2 !(0.55 inches for headings and margins; 0.2 inches per parameter)
	BWID=6.5
	CALL IGrArea(0.0,(BTOP-BHGT)/10.0,BWID/6.5,BTOP/10.0)
	CALL IGrUnits(0.0,-BHGT,BWID,0.0)  !Units are in inches rather than fraction
	CALL IGrLineWidth(1,10)
	CALL IGrBorder()
!Define Font Options and Write Section Heading
	CALL WGrTextOptions(GrTextRatio,RatioHeight)
	CALL WGrTextFont(FFHelvetica,ISTYLE=FSBold,HEIGHT=0.18/BHGT)
	CALL WGrTextOrientation(AlignCentre)
	CALL WGrTextString(3.25,-0.2,"Parameter Summary")
!Write Column Headings
	CALL WGrTextFont(FFHelvetica,ISTYLE=0,HEIGHT=0.16/BHGT)
	CALL WGrTextOrientation(AlignCentre)
	DO ICOL=1,5
		CALL WGrTextString(COLLOC(ICOL),-0.4,TRIM(HEADING(ICOL)))
	ENDDO
!Write Rows - Parameter Names, Guesses, Min/Max, MLE or Alt Estimate, CLs
	DO IPARM=1,NPARM
		CALL IGrCharOut(COLLOC(1),-0.4-IPARM*0.2,TRIM(PARMNAME(IPARM,MODELOPT)))
		CALL WGrTextDouble(COLLOC(2),-0.4-IPARM*0.2,PARMGUESS(IPARM),'(G10.4)')
		CALL WGrTextDouble(COLLOC(3),-0.4-IPARM*0.2,PARMMIN(IPARM),'(G10.4)')
		CALL WGrTextDouble(COLLOC(4),-0.4-IPARM*0.2,PARMMAX(IPARM),'(G10.4)')
		IF(CURVEFIT) THEN
			CALL WGrTextDouble(COLLOC(5),-0.4-IPARM*0.2,PARMSOLUT(IPARM),'(G10.4)')
		ELSE
			CALL IGrColour('Red')
			CALL WGrTextDouble(COLLOC(5),-0.4-IPARM*0.2,PARMSOLUT(IPARM),'(G10.4)')
			CALL IGrColour('Black')
		ENDIF
	ENDDO
!Update BTOP for Next Output Section
	BTOP=BTOP-BHGT-0.2
	RETURN
	END SUBROUTINE PRINTPARAM
