	SUBROUTINE PRINTPARAMOPT(BTOP)
	USE WINTERACTER
	USE SHAREDVARS
	USE RESOURCE
	REAL BTOP,BHGT,BWID,COLLOC(6)/0.3,1.0,2.25,3.5,4.75,6.0/
	REAL COLLOC2(11)/0.3,0.75,1.25,1.95,2.50,3.20,3.75,4.45,5.00,5.70,6.25/
	REAL OUT1,OUT2
	INTEGER IHIST,IPARM,IROW,IERR
!Define Graphics Area and Units for Parameter Grid; Outline Area 
	BWID=6.5
	BHGT=1.6
	CALL IGrArea(0.0,(BTOP-BHGT)/10.0,BWID/6.5,BTOP/10.0)
	CALL IGrUnits(0.0,-BHGT,BWID,0.0)
	CALL IGrLineWidth(1,10)
	CALL IGrBorder()
!Define Font Options and Write Section Heading
	CALL WGrTextOptions(GrTextRatio,RatioHeight)
	CALL WGrTextFont(FFHelvetica,ISTYLE=FSBold,HEIGHT=0.18/BHGT)
	CALL WGrTextOrientation(AlignCentre)
	CALL WGrTextString(3.25,-0.2,"Parameter Optimization History")
!Write Column Headings 
	CALL WGrTextFont(FFHelvetica,ISTYLE=0,HEIGHT=0.16/BHGT)
	CALL WGrTextOrientation(AlignCentre)
	CALL WGrTextString(COLLOC(1),-0.4,'Iter')
	CALL WGrTextString(COLLOC(2),-0.4,'-LogLike')
	DO IPARM=1,4
		CALL WGrTextString(COLLOC(IPARM+2),-0.4,PARMNAME(IPARM,MODELOPT))
	ENDDO
!Write Parameter Optimization History - 5 rows
	CALL WGrTextFont(FFHelvetica,ISTYLE=0,HEIGHT=0.14/BHGT)
    	DO IROW=1,5
    		IF(IROW.EQ.1) THEN
    			IHIST=1
    		ELSEIF(IROW.EQ.2) THEN
    			IHIST=HISTITER*0.10
    		ELSEIF(IROW.EQ.3) THEN
    			IHIST=HISTITER*0.25
    		ELSEIF(IROW.EQ.4) THEN
    			IHIST=HISTITER*0.50
    		ELSE
    			IHIST=HISTITER
    		ENDIF
		CALL WGrTextFont(FFHelvetica,ISTYLE=0,HEIGHT=0.13/BHGT)
    		CALL WGrTextInteger(COLLOC2(1),-0.4-0.2*IROW,IHIST,3)
    		CALL WGrTextDouble(COLLOC2(2),-0.4-0.2*IROW,HISTFUNC(IHIST),'(F10.4)')
    		DO IPARM=1,NPARM
			OUT1=HISTPARM(IHIST,IPARM)
			OUT2=HISTDFUN(IHIST,IPARM)
			CALL WGrTextReal(COLLOC2(2*IPARM+2),-0.4-0.2*IROW,OUT1,'(G10.4E1)')
			CALL WGrTextReal(COLLOC2(2*IPARM+3),-0.4-0.2*IROW,OUT2,'(G10.4E1)')
     		ENDDO
    	ENDDO
	BTOP=BTOP-BHGT-0.2
	END SUBROUTINE PRINTPARAMOPT
