	SUBROUTINE PRINTECP(BTOP)
	USE WINTERACTER
	USE SHAREDVARS
	USE RESOURCE
	CHARACTER(LEN=20) HEADING1(2) /"Log Transformed","Not Transformed"/
	CHARACTER(LEN=10) HEADING2(5) /"Variable","EC50","ECP","EC50","ECP"/
	REAL BTOP,BHGT,BWID,COLLOC2(5)/1.0,2.8,3.8,4.8,5.8/,COLLOC1(2)/3.3,5.3/
	INTEGER IPARM,ICOL,IVAR
!Define Graphics Area and Units for Parameter Grid; OutIPARM Area 
	BHGT=0.75+3*0.2 !(0.75 inches for headings and margins; 0.2 inches per variable)
	BWID=6.5
	CALL IGrArea(0.0,(BTOP-BHGT)/10.0,BWID/6.5,BTOP/10.0)
	CALL IGrUnits(0.0,-BHGT,BWID,0.0)  !Units are in inches rather than fraction
	CALL IGrLineWidth(1,10)
	CALL IGrBorder()
!Define Font Options and Write Section Heading
	CALL WGrTextOptions(GrTextRatio,RatioHeight)
	CALL WGrTextFont(FFHelvetica,ISTYLE=FSBold,HEIGHT=0.18/BHGT)
	CALL WGrTextOrientation(AlignCentre)
	CALL WGrTextString(3.25,-0.2,"Effect Concentration Summary")
!Write Column Headings
	CALL WGrTextFont(FFHelvetica,ISTYLE=0,HEIGHT=0.16/BHGT)
	CALL WGrTextOrientation(AlignCentre)
	DO ICOL=1,2
		CALL WGrTextString(COLLOC1(ICOL),-0.4,TRIM(HEADING1(ICOL)))
	ENDDO
	DO ICOL=1,5
		CALL WGrTextString(COLLOC2(ICOL),-0.6,TRIM(HEADING2(ICOL)))
	ENDDO
!Write Rows - Parameter Names, Guesses, Min/Max, MLE or Alt Estimate, CLs
	CALL WGrTextString(COLLOC2(1),-1.0,"Lower Conf Limit")
	CALL WGrTextString(COLLOC2(1),-1.2,"Upper Conf Limit")
	IF(CURVEFIT) THEN
		CALL WGrTextString(COLLOC2(1),-0.8,"EC Est - Maxlike")
		IF(XTRANSFORM.EQ.3) THEN
			CALL WGrTextDouble(COLLOC2(2),-0.8,LOG10(PARMSOLUT(2)),'(G10.4)')
			CALL WGrTextDouble(COLLOC2(3),-0.8,LOG10(ECPSOLUT),'(G10.4)')
			CALL WGrTextDouble(COLLOC2(4),-0.8,PARMSOLUT(2),'(G10.4)')
			CALL WGrTextDouble(COLLOC2(5),-0.8,ECPSOLUT,'(G10.4)')
			CALL WGrTextDouble(COLLOC2(2),-1.0,LOG10(PARMLCL(1)),'(G10.4)')
			CALL WGrTextDouble(COLLOC2(3),-1.0,LOG10(PARMLCL(2)),'(G10.4)')
			CALL WGrTextDouble(COLLOC2(4),-1.0,PARMLCL(1),'(G10.4)')
			CALL WGrTextDouble(COLLOC2(5),-1.0,PARMLCL(2),'(G10.4)')
			CALL WGrTextDouble(COLLOC2(2),-1.2,LOG10(PARMUCL(1)),'(G10.4)')
			CALL WGrTextDouble(COLLOC2(3),-1.2,LOG10(PARMUCL(2)),'(G10.4)')
			CALL WGrTextDouble(COLLOC2(4),-1.2,PARMUCL(1),'(G10.4)')
			CALL WGrTextDouble(COLLOC2(5),-1.2,PARMUCL(2),'(G10.4)')
		ELSE
			CALL WGrTextDouble(COLLOC2(2),-0.8,PARMSOLUT(2),'(G10.4)')
			CALL WGrTextDouble(COLLOC2(3),-0.8,ECPSOLUT,'(G10.4)')
			CALL WGrTextDouble(COLLOC2(4),-0.8,10D0**(PARMSOLUT(2)),'(G10.4)')
			CALL WGrTextDouble(COLLOC2(5),-0.8,10D0**(ECPSOLUT),'(G10.4)')
			CALL WGrTextDouble(COLLOC2(2),-1.0,PARMLCL(1),'(G10.4)')
			CALL WGrTextDouble(COLLOC2(3),-1.0,PARMLCL(2),'(G10.4)')
			CALL WGrTextDouble(COLLOC2(4),-1.0,10D0**(PARMLCL(1)),'(G10.4)')
			CALL WGrTextDouble(COLLOC2(5),-1.0,10D0**(PARMLCL(2)),'(G10.4)')
			CALL WGrTextDouble(COLLOC2(2),-1.2,PARMUCL(1),'(G10.4)')
			CALL WGrTextDouble(COLLOC2(3),-1.2,PARMUCL(2),'(G10.4)')
			CALL WGrTextDouble(COLLOC2(4),-1.2,10D0**(PARMUCL(1)),'(G10.4)')
			CALL WGrTextDouble(COLLOC2(5),-1.2,10D0**(PARMUCL(2)),'(G10.4)')
		ENDIF
	ELSE
		CALL IGrColour('Red')
		CALL WGrTextString(COLLOC2(1),-0.8,"EC Est - Midpoint")
		IF(XTRANSFORM.EQ.3) THEN
			CALL WGrTextDouble(COLLOC2(2),-1.4,LOG10(PARMALT(2)),'(G10.4)')
			CALL WGrTextDouble(COLLOC2(3),-1.4,LOG10(ECPALT),'(G10.4)')
			CALL WGrTextDouble(COLLOC2(4),-1.4,PARMALT(2),'(G10.4)')
			CALL WGrTextDouble(COLLOC2(5),-1.4,ECPALT,'(G10.4)')
			CALL IGrColour('Black')
			CALL WGrTextDouble(COLLOC2(2),-0.8,LOG10(PARMLCL(1)),'(G10.4)')
			CALL WGrTextDouble(COLLOC2(3),-0.8,LOG10(PARMLCL(2)),'(G10.4)')
			CALL WGrTextDouble(COLLOC2(4),-0.8,PARMLCL(1),'(G10.4)')
			CALL WGrTextDouble(COLLOC2(5),-0.8,PARMLCL(2),'(G10.4)')
			CALL WGrTextDouble(COLLOC2(2),-1.2,LOG10(PARMUCL(1)),'(G10.4)')
			CALL WGrTextDouble(COLLOC2(3),-1.2,LOG10(PARMUCL(2)),'(G10.4)')
			CALL WGrTextDouble(COLLOC2(4),-1.2,PARMUCL(1),'(G10.4)')
			CALL WGrTextDouble(COLLOC2(5),-1.2,PARMUCL(2),'(G10.4)')
		ELSE
			CALL WGrTextDouble(COLLOC2(2),-0.8,PARMALT(2),'(G10.4)')
			CALL WGrTextDouble(COLLOC2(3),-0.8,ECPALT,'(G10.4)')
			CALL WGrTextDouble(COLLOC2(4),-0.8,10D0**(PARMALT(2)),'(G10.4)')
			CALL WGrTextDouble(COLLOC2(5),-0.8,10D0**(ECPALT),'(G10.4)')
			CALL IGrColour('Black')
			CALL WGrTextDouble(COLLOC2(2),-1.0,PARMLCL(1),'(G10.4)')
			CALL WGrTextDouble(COLLOC2(3),-1.0,PARMLCL(2),'(G10.4)')
			CALL WGrTextDouble(COLLOC2(4),-1.0,10D0**(PARMLCL(1)),'(G10.4)')
			CALL WGrTextDouble(COLLOC2(5),-1.0,10D0**(PARMLCL(2)),'(G10.4)')
			CALL WGrTextDouble(COLLOC2(2),-1.2,PARMUCL(1),'(G10.4)')
			CALL WGrTextDouble(COLLOC2(3),-1.2,PARMUCL(2),'(G10.4)')
			CALL WGrTextDouble(COLLOC2(4),-1.2,10D0**(PARMUCL(1)),'(G10.4)')
			CALL WGrTextDouble(COLLOC2(5),-1.2,10D0**(PARMUCL(2)),'(G10.4)')
		ENDIF
	ENDIF
!Update BTOP for Next Output Section
	BTOP=BTOP-BHGT-0.2
	RETURN
	END SUBROUTINE PRINTECP
