 	SUBROUTINE PRINTDATA(BTOP)
	USE WINTERACTER
	USE SHAREDVARS
	USE RESOURCE
	CHARACTER(LEN=8) COLHEAD(12)/"Exposure","Initial#","  Final#","Exposure","Initial#","  Final#","Exposure","Initial#","  Final#","Exposure","Initial#","  Final#"/
	REAL BTOP,BHGT,BWID,YLOC,COLLOC(12)/0.45,0.95,1.3, 2.05,2.55,2.9, 3.65,4.15,4.5, 5.25,5.75,6.1/
	INTEGER IDAT,ICOL,ISECT
!Define Graphics Area and Units for Parameter Grid; Outline Area 
	BWID=6.5
	BHGT=0.55+25*0.18
	CALL IGrArea(0.0,(BTOP-BHGT)/10.0,BWID/6.5,BTOP/10.0)
	CALL IGrUnits(0.0,-BHGT,BWID,0.0)
	CALL IGrLineWidth(1,10)
	CALL IGrBorder()
!Define Font Options and Write Section Heading
	CALL WGrTextOptions(GrTextRatio,RatioHeight)
	CALL WGrTextFont(FFHelvetica,ISTYLE=FSBold,HEIGHT=0.18/BHGT)
	CALL WGrTextOrientation(AlignCentre)
	CALL WGrTextString(3.25,-0.2,"Data Summary")
!Write Column Headings 
	CALL WGrTextFont(FFHelvetica,ISTYLE=0,HEIGHT=0.14/BHGT)
	CALL WGrTextOrientation(AlignCentre)
	DO ICOL=1,12
		CALL WGrTextString(COLLOC(ICOL),-0.4,COLHEAD(ICOL))
	ENDDO
!Write Data (there are 4 sections for table, each with 25 rows. ISECT specified section. YLOC cycles through rows.
	DO IDAT=1,MIN(100,NDAT)
		YLOC=-0.4-0.17*(MOD(IDAT-1,25)+1)
		ISECT=INT((IDAT-0.1)/25)
		type *,'data table',idat,yloc,isect
		IF(XTRANSFORM.EQ.3) THEN
			CALL WGrTextDouble(COLLOC(1+ISECT*3),YLOC,XDAT(IDAT),'(G9.3E1)')
		ELSE
			CALL WGrTextDouble(COLLOC(1+ISECT*3),YLOC,XDAT(IDAT),'(F7.3)')
		ENDIF
		CALL WGrTextInteger(COLLOC(2+ISECT*3),YLOC,NINT(MDAT(IDAT)),3)
		CALL WGrTextInteger(COLLOC(3+ISECT*3),YLOC,NINT(YDAT(IDAT)),3)
	ENDDO
	RETURN
	END SUBROUTINE PRINTDATA

