	SUBROUTINE PRINTCLCALCS(BTOP)
	USE WINTERACTER
	USE SHAREDVARS
	USE RESOURCE
	REAL BTOP,BHGT,BWID,COLLOC(7)/0.6,1.6,2.6,3.6,4.4,5.2,6.0/,YLOC
	INTEGER ICOL
	CHARACTER(LEN=8) NUMBER
	CHARACTER(LEN=10) COLNAME(7)/'Variable','logLike@CL','CLValue','Parm1','Parm2','Parm3','Parm4'/
	CHARACTER(LEN=10) ROWNAME(5)/'EC50 LCL','EC50 UCL','ECP LCL','ECP UCL','Scale UCL'/
	ROWNAME(3)=ECPNAME//' LCL'
	ROWNAME(4)=ECPNAME//' UCL'
!Define Graphics Area and Units for Parameter Grid; Outline Area 
	BWID=6.5
	BHGT=1.8
	CALL IGrArea(0.0,(BTOP-BHGT)/10.0,BWID/6.5,BTOP/10.0)
	CALL IGrUnits(0.0,-BHGT,BWID,0.0)
	CALL IGrLineWidth(1,10)
	CALL IGrBorder()
!Define Font Options and Write Section Heading
	CALL WGrTextOptions(GrTextRatio,RatioHeight)
	CALL WGrTextFont(FFHelvetica,ISTYLE=FSBold,HEIGHT=0.18/BHGT)
	CALL WGrTextOrientation(AlignCentre)
	CALL WGrTextString(3.25,-0.2,"ECP Confidence Limits Information")
	CALL WGrTextFont(FFHelvetica,ISTYLE=0,HEIGHT=0.14/BHGT)
	WRITE(UNIT=NUMBER,FMT='(F8.4)') LIKETARGET
	CALL WGrTextOrientation(AlignLeft)
	CALL WGrTextString(0.15,-0.2,"(LogLikelihoodTarget: "//NUMBER//")")
	CALL WGrTextFont(FFHelvetica,ISTYLE=0,HEIGHT=0.16/BHGT)
	CALL WGrTextOrientation(AlignCentre)
	CALL WGrTextString(4.8,-0.4,"Reoptimized Parameters at CL ")
!Write Column and Row Labels  
	CALL WGrTextOrientation(AlignCentre)
	CALL WGrTextFont(FFHelvetica,ISTYLE=0,HEIGHT=0.16/BHGT)
	DO ICOL=1,7
		CALL WGrTextString(COLLOC(ICOL),-0.6,TRIM(COLNAME(ICOL)))
	ENDDO
	CALL WGrTextFont(FFHelvetica,ISTYLE=0,HEIGHT=0.14/BHGT)
	YLOC=-0.8
	CALL WGrTextString(COLLOC(1),YLOC,ROWNAME(1))
      CALL WGrTextDouble(COLLOC(2),YLOC,FUNCLCL(1),'(F10.4)')
      CALL WGrTextDouble(COLLOC(3),YLOC,PARMLCL(1),'(G10.4)')
      CALL WGrTextDouble(COLLOC(4),YLOC,OPTPARMATLCL(1,1),'(G10.4)')
      CALL WGrTextDouble(COLLOC(6),YLOC,OPTPARMATLCL(2,1),'(G10.4)')
      IF(NPARM.GT.3) CALL WGrTextDouble(COLLOC(7),YLOC,OPTPARMATLCL(3,1),'(G10.4)')
	YLOC=-1.0
	CALL WGrTextString(COLLOC(1),YLOC,ROWNAME(2))
      CALL WGrTextDouble(COLLOC(2),YLOC,FUNCUCL(1),'(F10.4)')
      CALL WGrTextDouble(COLLOC(3),YLOC,PARMUCL(1),'(G10.4)')
      CALL WGrTextDouble(COLLOC(4),YLOC,OPTPARMATUCL(1,1),'(G10.4)')
      CALL WGrTextDouble(COLLOC(6),YLOC,OPTPARMATUCL(2,1),'(G10.4)')
      IF(NPARM.GT.3) CALL WGrTextDouble(COLLOC(7),YLOC,OPTPARMATUCL(3,1),'(G10.4)')
	YLOC=-1.2
	CALL WGrTextString(COLLOC(1),YLOC,ROWNAME(3))
      CALL WGrTextDouble(COLLOC(2),YLOC,FUNCLCL(2),'(F10.4)')
      CALL WGrTextDouble(COLLOC(3),YLOC,PARMLCL(2),'(G10.4)')
      CALL WGrTextDouble(COLLOC(4),YLOC,OPTPARMATLCL(1,2),'(G10.4)')
      CALL WGrTextDouble(COLLOC(6),YLOC,OPTPARMATLCL(2,2),'(G10.4)')
      IF(NPARM.GT.3) CALL WGrTextDouble(COLLOC(7),YLOC,OPTPARMATLCL(3,2),'(G10.4)')
	YLOC=-1.4
	CALL WGrTextString(COLLOC(1),YLOC,ROWNAME(4))
      CALL WGrTextDouble(COLLOC(2),YLOC,FUNCUCL(2),'(F10.4)')
      CALL WGrTextDouble(COLLOC(3),YLOC,PARMUCL(2),'(G10.4)')
      CALL WGrTextDouble(COLLOC(4),YLOC,OPTPARMATUCL(1,2),'(G10.4)')
      CALL WGrTextDouble(COLLOC(6),YLOC,OPTPARMATUCL(2,2),'(G10.4)')
      IF(NPARM.GT.3) CALL WGrTextDouble(COLLOC(7),YLOC,OPTPARMATUCL(3,2),'(G10.4)')
	IF(.NOT.CURVEFIT) THEN
		YLOC=-1.6
		CALL WGrTextString(COLLOC(1),YLOC,ROWNAME(5))
		CALL WGrTextDouble(COLLOC(2),YLOC,FUNCUCL(3),'(F10.4)')
		CALL WGrTextDouble(COLLOC(3),YLOC,PARMUCL(3),'(G10.4)')
		CALL WGrTextDouble(COLLOC(4),YLOC,OPTPARMATUCL(1,3),'(G10.4)')
		CALL WGrTextDouble(COLLOC(5),YLOC,OPTPARMATUCL(2,3),'(G10.4)')
		IF(NPARM.GT.3) CALL WGrTextDouble(COLLOC(7),YLOC,OPTPARMATUCL(3,3),'(G10.4)')
	ENDIF
	BTOP=BTOP-BHGT-0.2
	END SUBROUTINE PRINTCLCALCS

