!******************
!***Main Program***
!******************
	PROGRAM TRAP_MAIN
	USE WINTERACTER
	USE RESOURCE
	USE SHAREDVARS
	TYPE(WIN_MESSAGE) MESSAGE
	LOGICAL QUIT /.FALSE./
	INTEGER ITYPE,IPARM,PTARGETINT,IMOD
	EXTERNAL PRINTEROUTPUT,COPYGRAPH,PREDLINEPTS,CSVFILE,GRAPHPARMCL,CLINFO,ABOUT,GRAPHLINECL!,CLLINE
	EXTERNAL GETDATA,GRAPHDATA,GRAPHLINE,GRAPHOPTIONS,INITIALGUESSES,CLEARGRAPH,CLEARLINE,CLEARANALYSIS,CLEARGUESSES,PARMCALC,WEXIT,OPTIMHIST,PRINTERSELECT
	CALL IDebugLevel(1)
!***
!***Initialize Winteracter and open root window
!***
	CALL WInitialise()
	CALL WindowOpen( &
	FLAGS=SysMenuOn+MinButton+FixedSizeWin,X=200,Y=200,&
	MENUID=IDR_MENU1, &
	DIALOGID=IDD_MAIN, &
	TITLE="Survival Analysis Program")
!***
!***Select main dialog for focus and enable reporting of FieldChanged messages, select display graphic area
!***
	CALL WDialogSelect(IDD_MAIN)
	CALL WMessageEnable(FieldChanged,Enabled)
	CALL WDialogFieldOptions(IDF_MAIN_DATASET_GRID,EditFieldChanged,1)
	CALL IGrSelect(3,IDF_MAIN_GRAPH_FRAME)
!***
!***Main message loop - get messages from Main dialog until QUIT=TRUE and start SELECT structure for message type
!***
	DO WHILE(.NOT.QUIT)
		CALL WMessage(ITYPE,MESSAGE)
		type "('****MESSAGE****',7I10)",itype,message%win,message%value1,message%value2,message%value3,MESSAGE%X,MESSAGE%Y
		SELECT CASE (ITYPE)
!***
!***MENU ITEM SELECTED - call corresponding routine
!***
		CASE (MenuSelect)
			SELECT CASE(MESSAGE%VALUE1)
        			CASE (ID_ANALYSIS_GRAPHDATA)
					CALL GETDATA()
        				CALL GRAPHDATA()
        				IF(PARMESTDONE) CALL GRAPHLINE()
					IF(PARMCONFDONE) THEN
						DO CLOPT=1,2
						CALL GRAPHPARMCL()
						ENDDO
					ENDIF
					IF(LINECONFDONE) CALL GRAPHLINECL()
				CASE (ID_ANALYSIS_INITIALGUESSES)
					CALL INITIALGUESSES
        			CASE (ID_ANALYSIS_PARMCALC)
					PARMESTDONE=.FALSE.
					PARMCONFDONE=.FALSE.
					CALL WGridClear(IDF_MAIN_ECP_GRID)
        				CALL PARMCALC()
        			CASE (ID_ANALYSIS_GRAPHOPTIONS)
        				CALL GRAPHOPTIONS()
        			CASE (ID_ANALYSIS_ABOUT)
					CALL ABOUT()
        			CASE (ID_ANALYSIS_EXIT)
					CALL WEXIT(QUIT)
        			CASE (ID_OUTPUT_PREDLINEPTS)
        				CALL PREDLINEPTS()
        			CASE (ID_OUTPUT_PRINTEROUTPUT)
        				CALL PRINTEROUTPUT()
        			CASE (ID_OUTPUT_COPYGRAPH)
        				CALL COPYGRAPH()
        			CASE (ID_OUTPUT_CSVFILE)
					CALL CSVFILE()
			END SELECT
!***
!***QUIT request other than from menu 
!***
		CASE (CloseRequest)
			CALL WEXIT(QUIT)
!***
!***PUSHBUTTON DETECTED	
!***
		CASE (PushButton)
!***
!***Winteracter reports change to PTARGET as "PushButton" rather than "FieldChanged" (i.e., bug), and identifies PTARGET field under Message&Value2
!***  (a) Update PTARGET 
!***  (b) Update parameter names
!***  (c) Clear analysis results (includes clearing graphed line) and parameter guesses  
!***
			SELECT CASE (MESSAGE%VALUE2)
				CASE(IDF_MAIN_PTARGET_INTEGER) 
					Call WDialogGetInteger(IDF_MAIN_PTARGET_INTEGER,PTARGETINT)
					TYPE *,PTARGETINT
					WRITE(ECPNAME,"('EC',I2)") PTARGETINT
					PTARGET(2)=PTARGETINT/1D2
					CALL WGridLabelColumn(IDF_MAIN_ECP_GRID,3,ECPNAME//'-LogTrans')
					CALL WGridLabelColumn(IDF_MAIN_ECP_GRID,4,ECPNAME//'-NotTrans')
					TYPE *,'NEW ECP TARGET',PTARGETINT,PTARGET (2)
          				CALL CLEARANALYSIS()
					CALL CLEARGUESSES()
					CALL CLEARGRAPH()
			END SELECT

!***
!***FIELDCHANGED DETECTED (Change of focus from one field to other or data entry into current field)
!***
		CASE (FieldChanged)
!***
!***If Fieldchanged is Model Option and Value Has Changed:
!***  (a) Update MODELOPT 
!***  (b) Enter parameter names for MODELOPT in parameters grid
!***  (c) Clear analysis results (includes clearing graphed line) and parameter guesses  
!***
			IF(MESSAGE%VALUE1.EQ.IDF_MAIN_MODOPT_MENU.AND.MESSAGE%VALUE3.EQ.1) THEN
				Call WDialogGetMenu(IDF_MAIN_MODOPT_MENU,MODELOPT)
				DO IPARM=1,4
					CALL WGridLabelRow(IDF_MAIN_PARAMETERS_GRID,IPARM,PARMNAME(IPARM,MODELOPT))
				ENDDO
          			CALL CLEARANALYSIS()
				CALL CLEARGUESSES()
				CALL CLEARGRAPH()
				TYPE *,'NEW MODELOPT',MODELOPT
			ENDIF
!***
!***If Fieldchanged is XTRANFORM and Value Has Changed:
!***  (a) Update XTRANSFORM 
!***  (b) Clear analysis results (includes clearing graphed line) and parameter guesses  
!***
			IF(MESSAGE%VALUE1.EQ.IDF_MAIN_XTRANSFORM_MENU.AND.MESSAGE%VALUE3.EQ.1) THEN
				Call WDialogGetMenu(IDF_MAIN_XTRANSFORM_MENU,XTRANSFORM)
				DO IPARM=1,4
					CALL WGridLabelRow(IDF_MAIN_PARAMETERS_GRID,IPARM,PARMNAME(IPARM,MODELOPT))
				ENDDO
          			CALL CLEARANALYSIS()
				CALL CLEARGUESSES()
				CALL CLEARGRAPH()
				TYPE *,'NEW XTRANSFORM',XTRANSFORM
			ENDIF
!***
!***If Fieldchanged is in Data Grid and some change has been made
!***  (a) Clear analysis results but not parameter guesses
!***  (b) Clear graphed data
!***
			IF(MESSAGE%VALUE1.EQ.IDF_MAIN_DATASET_GRID.AND.MESSAGE%VALUE3.EQ.1) THEN
				CALL CLEARANALYSIS()
				CALL CLEARGUESSES()
				CALL CLEARGRAPH()
			ENDIF
!***
!***Winteracter reports PushButton with a double message, the first being the pushbutton and the second being 
!***a shift of focus back to the previous location in the dialog which is a FieldChanged, not PushButton
!***So need to process pushbutton as a fieldchanged, with Message%Value2 being the actual button
!*** 
			IF(MESSAGE%VALUE2.EQ.IDF_MAIN_OPTHIST_BUTTON) THEN 
				type *,'Using button for optimization history'
				CALL OPTIMHIST()
			ENDIF
			IF(MESSAGE%VALUE2.EQ.IDF_MAIN_CLINFO_BUTTON) THEN 
				type *,'Using button for CL information'
				CALL CLINFO()
			ENDIF


		END SELECT
!***
!***End main Do loop if QUIT = .TRUE., close main window, and end program
!***
	END DO
	CALL WindowClose()
	STOP
	END PROGRAM TRAP_MAIN

!****************************************************************
!***Query Intention to Exit Program and Set QUIT Logical State***
!****************************************************************
	SUBROUTINE WEXIT(QUIT)
	USE WINTERACTER
	IMPLICIT NONE
	LOGICAL QUIT
	CALL WMessageBox(YesNo,QuestionIcon,CommonYes,'Do you really want to quit?','Exit Program')
	IF (WInfoDialog(4).EQ.2) THEN 
		QUIT=.FALSE.
	ELSE
		QUIT=.TRUE.
	ENDIF
	RETURN
	END SUBROUTINE WEXIT

	SUBROUTINE ABOUT()
	USE WINTERACTER
	USE SHAREDVARS
	USE RESOURCE
	CALL WDialogLoad(IDD_ABOUT)
	CALL WDialogShow(-1,-1,IDD_ABOUT,MODAL)
	CALL WDialogUnload()
	CALL WDialogSelect(IDD_MAIN)
	RETURN
	END SUBROUTINE ABOUT


