!*************************************************************
!***Program Can Guess if User Does Not Want to Provide Them***
!*************************************************************
	SUBROUTINE INITIALGUESSES()
	USE WINTERACTER
	USE RESOURCE
	USE SHAREDVARS
	INTEGER IPARM,ITRT,JTRT,JCHECK,NREG1,NREG2,NREG,IPTMAX,IPTMIN
	REAL*8 NORMPZ,SUM
	REAL*8 X0,X50,X100,RANGE,STDV
	REAL*8 PI/3.14159265/
	REAL*8 REGSLOPE,REGINTER,SUMX,SUMX2,SUMY,SUMXY,LOGIT,FRACY
	EXTERNAL NORMPZ,GETDATA
	NPARM=NPARMMOD(MODELOPT)
!***
!***Clear dialogs and reload data to insure up-to-date
!***
	CALL WGridClear(IDF_MAIN_PARAMETERS_GRID)
	CALL WDialogClearField(IDF_MAIN_NCTRL_INTEGER)
	CALL WDialogClearField(IDF_MAIN_NPART_INTEGER)
	CALL WDialogClearField(IDF_MAIN_NFULL_INTEGER)
	CALL GETDATA()
!***
!***Inference of number of treatments on control plateau (NCTRL) and average survival on this plateau (CONTROLAVG)
!***First, identify highest treatment with highest survival (IPTMAX)
!***Second, identify treatment below IPTMAX with lowest survival (IPTMIN)
!***Then, set NCTRL based on treatment that is past IPTMAX, has survival less than at IPTMIN, and has survival >=90% of average of lower treatments 
!***
	IPTMAX=1
	DO ITRT=2,NTRT
		IF(YTRTFRAC(ITRT).GE.YTRTFRAC(IPTMAX)) IPTMAX=ITRT  
	ENDDO
	TYPE *,'IPTMAX',IPTMAX
	IPTMIN=1
	DO ITRT=2,IPTMAX
		IF(YTRTFRAC(ITRT).LT.YTRTFRAC(IPTMIN)) IPTMIN=ITRT
	ENDDO
	TYPE *,'IPTMIN',IPTMIN
	NCTRL=1
	SUM=YTRTFRAC(1)
	TYPE *,1,NCTRL,SUM
	DO ITRT=2,NTRT
		IF(ITRT.GT.IPTMAX) THEN!.AND.YTRTFRAC(ITRT).LT.YTRTFRAC(IPTMIN)) THEN
			JCHECK=0
			DO JTRT=ITRT+1,NTRT
				IF(YTRTFRAC(JTRT).GT.0.9*SUM/(ITRT-1)) JCHECK=1 
			ENDDO
			IF(JCHECK.EQ.0) EXIT
		ENDIF
		SUM=SUM+YTRTFRAC(ITRT)
		NCTRL=NCTRL+1
		TYPE *,ITRT,NCTRL,SUM/ITRT
	ENDDO
	CONTROLAVG=SUM/(ITRT-1)
	TYPE *,'CONTROLAVG',CONTROLAVG
!***
!***NFULL is number of treatments with no survival
!***
	NFULL=0
	DO ITRT=NTRT,1,-1
		IF(YTRTFRAC(ITRT).LT.0.01) NFULL=NFULL+1
	ENDDO
!***
!***NPART by difference
!***
	NPART=NTRT-NCTRL-NFULL
	CALL WDialogPutInteger(IDF_MAIN_NCTRL_INTEGER,NCTRL)
	CALL WDialogPutInteger(IDF_MAIN_NPART_INTEGER,NPART)
	CALL WDialogPutInteger(IDF_MAIN_NFULL_INTEGER,NFULL)
!***
!***Set guess for control parameter to CONTROLAVG and set min/max for this parameter
!***This value is simply the initial guess for curve, so does not affect EC estimation, 
!***
	PARMGUESS(1)=MIN(0.99,CONTROLAVG)
	PARMMIN(1)=0.7D0
	PARMMAX(1)=0.9999D0
!***
!***Do linear logit regression for approximate line extending from NCTRL (point 2 if NCTRL=1) to NCTRL+NPART+1 (NTRT if NFULL=0)
!***This is rough estimate for the rectangular distribution - just to get some approximate initial guesses for parameters
!***Set estimates for mean, stdv, range based on this
!***
	SUMX=0.0
	SUMY=0.0
	SUMX2=0.0
	SUMXY=0.0
      NREG1=MAX(NCTRL,2)
      NREG2=MIN(NTRT-NFULL+1,NTRT)
      NREG=NREG2-NREG1+1
	TYPE *,'NREG',NREG1,NREG2,NREG
	DO ITRT=NREG1,NREG2
		SUMX=SUMX+XTRT(ITRT)
		SUMX2=SUMX2+XTRT(ITRT)**2
            FRACY=MIN(MAX(YTRTFRAC(ITRT)/CONTROLAVG,0.02),0.98)
		LOGIT=LOG(FRACY/(1D0-FRACY))
		SUMY=SUMY+LOGIT
		SUMXY=SUMXY+XTRT(ITRT)*LOGIT
		TYPE "(I5,4F15.4)",ITRT,SUMX,SUMX2,SUMY,SUMXY
	ENDDO
	REGSLOPE=(SUMXY-SUMX*SUMY/NREG)/(SUMX2-SUMX**2/NREG)
      REGINTER=SUMY/NREG-REGSLOPE*SUMX/NREG
      X50=-REGINTER/REGSLOPE
      STDV=-1.8/REGSLOPE
      X0=(3-REGINTER)/REGSLOPE
      X100=(-3-REGINTER)/REGSLOPE
	RANGE=X100-X0
	TYPE *,REGSLOPE,REGINTER
	TYPE *,X50,STDV
	TYPE *,X0,X100
!***
!***Set other parameter guesses for each model
!***
	IF(MODELOPT.EQ.1) THEN
		PARMGUESS(3)=STDV/2  !2/STDV
		PARMGUESS(2)=X50
	ELSEIF(MODELOPT.EQ.2) THEN
		PARMGUESS(3)=STDV
		PARMGUESS(2)=X50
	ELSEIF(MODELOPT.EQ.3) THEN
		PARMGUESS(3)=RANGE
		PARMGUESS(2)=X50
	ELSEIF(MODELOPT.EQ.4) THEN
		PARMGUESS(3)=RANGE
		PARMGUESS(2)=X50
	ELSEIF(MODELOPT.EQ.5) THEN
		PARMGUESS(3)=STDV*SQRT(6.0)/PI
		PARMGUESS(2)=X50-PARMGUESS(3)*LOG(-LOG(0.5))
	ELSEIF(MODELOPT.EQ.6) THEN
		PARMGUESS(3)=STDV*SQRT(6.0)/PI
		PARMGUESS(2)=X50+PARMGUESS(3)*LOG(-LOG(0.5))
	ELSEIF(MODELOPT.EQ.7) THEN
		PARMGUESS(3)=1/STDV
		PARMGUESS(2)=X0-LOG(0.5)/PARMGUESS(3)
	ELSEIF(MODELOPT.EQ.8) THEN
		PARMGUESS(4)=0.5D0
		PARMGUESS(3)=RANGE
		PARMGUESS(2)=X50
	ELSEIF(MODELOPT.EQ.9) THEN
		PARMGUESS(4)=0D0
		PARMGUESS(3)=STDV*SQRT(3.0)/PI
		PARMGUESS(2)=X50
	ELSEIF(MODELOPT.EQ.10) THEN
		PARMGUESS(4)=-2D0
		PARMGUESS(3)=STDV*SQRT(3.0)/PI
		PARMGUESS(2)=X50
	ENDIF
	IF(XTRANSFORM.EQ.3) THEN
		PARMMIN(2)=PARMGUESS(2)/3
		PARMMAX(2)=PARMGUESS(2)*3
	ELSE 
		PARMMIN(2)=PARMGUESS(2)-0.4
		PARMMAX(2)=PARMGUESS(2)+0.4
	ENDIF
	PARMMIN(3)=PARMGUESS(3)/3
	PARMMAX(3)=PARMGUESS(3)*3
	IF(MODELOPT.EQ.8) THEN
		PARMMIN(4)=0.01D0
		PARMMAX(4)=0.99D0
	ELSEIF(MODELOPT.EQ.9) THEN
		PARMMIN(4)=-2D0
		PARMMAX(4)=2D0
	ELSEIF(MODELOPT.EQ.10) THEN
		PARMMIN(4)=-4D0
		PARMMAX(4)=2D0
	ENDIF
!***
!***Put guesses and limits in grid
!***
	DO IPARM=1,NPARM
		CALL WGridPutCellDouble(IDF_MAIN_PARAMETERS_GRID,1,IPARM,PARMGUESS(IPARM))
		CALL WGridPutCellDouble(IDF_MAIN_PARAMETERS_GRID,2,IPARM,PARMMIN(IPARM))
		CALL WGridPutCellDouble(IDF_MAIN_PARAMETERS_GRID,3,IPARM,PARMMAX(IPARM))
	ENDDO
      RETURN
	END SUBROUTINE INITIALGUESSES

