!******************************************
!***Changes to Graphing Format Variables***
!******************************************
	SUBROUTINE GRAPHOPTIONS()
	USE WINTERACTER
	USE RESOURCE
	USE SHAREDVARS
	TYPE(WIN_MESSAGE) MESSAGE
	LOGICAL QUIT
	INTEGER ITYPE
	EXTERNAL GRAPHDATA,GRAPHLINE,GRAPHPARMCL
!***
!***Select and show Graph Options dialog (already loaded, but hidden)
!***
	CALL WDialogLoad(IDD_GRAPHOPT)
	CALL WDialogSelect(IDD_GRAPHOPT)
	CALL WDialogShow(MODELESS)!(100,100,0,SEMIMODELESS)
!***
!***Fill table with current option info 
!***
	
	CALL WDialogPutString(IDF_GRAPHOPT_XAXISLABEL_STRING,XLABEL)
	CALL WDialogPutString(IDF_GRAPHOPT_YAXISLABEL_STRING,YLABEL)
	CALL WGridPutCellReal(IDF_GRAPHOPT_FORMATINFO_GRID,1,1,RELSIZEHEAD)
	CALL WGridPutCellReal(IDF_GRAPHOPT_FORMATINFO_GRID,1,2,RELSIZEAXIS)
	CALL WGridPutCellReal(IDF_GRAPHOPT_FORMATINFO_GRID,1,3,RELSIZETIC)
	CALL WGridPutCellReal(IDF_GRAPHOPT_FORMATINFO_GRID,1,4,RELASPECT)
	CALL WGridPutCellReal(IDF_GRAPHOPT_FORMATINFO_GRID,1,5,RELTHICKAXIS)
	CALL WGridPutCellReal(IDF_GRAPHOPT_FORMATINFO_GRID,1,6,RELTHICKPLOT)
	CALL WGridPutCellReal(IDF_GRAPHOPT_FORMATINFO_GRID,1,7,RELSIZESYMB)
!***
!***Main message loop - check for quit request and for field changes
!***
	QUIT=.FALSE.
	DO WHILE(.NOT.QUIT)
		CALL WMessage(ITYPE,MESSAGE)
		SELECT CASE (ITYPE)
!***
!***Set QUIT to .TRUE. to exit loop if Close button is pushed without saving any changes 
!***
		CASE (CloseRequest)
			QUIT=.TRUE.
!***
!***Save changes and set QUIT to .TRUE. to exit loop if Save button is pushed
!***
		CASE (Pushbutton)
			SELECT CASE (MESSAGE%VALUE1)
			CASE (IDF_GRAPHOPT_SAVE_BUTTON)
				CALL WGridGetCellReal(IDF_GRAPHOPT_FORMATINFO_GRID,1,1,RELSIZEHEAD)
				CALL WGridGetCellReal(IDF_GRAPHOPT_FORMATINFO_GRID,1,2,RELSIZEAXIS)
				CALL WGridGetCellReal(IDF_GRAPHOPT_FORMATINFO_GRID,1,3,RELSIZETIC)
				CALL WGridGetCellReal(IDF_GRAPHOPT_FORMATINFO_GRID,1,4,RELASPECT)
				CALL WGridGetCellReal(IDF_GRAPHOPT_FORMATINFO_GRID,1,5,RELTHICKAXIS)
				CALL WGridGetCellReal(IDF_GRAPHOPT_FORMATINFO_GRID,1,6,RELTHICKPLOT)
				CALL WGridGetCellReal(IDF_GRAPHOPT_FORMATINFO_GRID,1,7,RELSIZESYMB)
				CALL WDialogGetString(IDF_GRAPHOPT_XAXISLABEL_STRING,XLABEL)
				CALL WDialogGetString(IDF_GRAPHOPT_YAXISLABEL_STRING,YLABEL)
				QUIT=.TRUE.
			CASE (IDF_GRAPHOPT_CANCEL_BUTTON)
				QUIT=.TRUE.
			CASE (IDCANCEL)
				QUIT=.TRUE.
			END SELECT
!***
!***End message monitoring
!***
		END SELECT
	ENDDO
!***
!***Hide dialog and return to Main dialog and calling routine
!***
	CALL WDialogUnload()
	CALL WDialogSelect(IDD_MAIN)
	IF(DATAPLOTDONE) CALL GRAPHDATA()
	IF(PARMESTDONE) CALL GRAPHLINE()
!	IF(PARMESTDONE) CALL GRAPHPARM()
	IF(PARMCONFDONE) CALL GRAPHPARMCL()
!	IF(LINECONFDONE) CALL GRAPHLCL()
!	IF(LINECONFDONE) CALL GRAPHUCL()
	RETURN
	END SUBROUTINE GRAPHOPTIONS

