!*******************************
!***Draw Data and Model Plots***
!*******************************
	SUBROUTINE GRAPHDATA()
	USE WINTERACTER
	USE RESOURCE
	USE SHAREDVARS
	INTEGER NXTICS,NYTICS,NDECX,NDECY,IPLOT,ITIC,EXPO,ITRT,ILINE
	REAL XMIN,XMAX,XRANGE,XNORMRANGE,XTICSTEP,XTICS(20),XCL(2)
	REAL YMIN,YMAX,YTICSTEP,YMINTIC,YMAXTIC,YTICS(20),YCL(2)
	 PRINT *,'IN GRAPHDATA - PREPARING TO CLEAR GRAPHICS AREA'
!***
!***If insufficient data to plot:
!***    (1) Give message to that effect
!***    (2) Set DATAPLOTDONE to FALSE
!***    (3) Exit to calling program 
!***
	IF(NPLOT.LT.3) THEN
		Call WMessageBox(OKOnly,StopIcon,CommonOK,'Insufficient Data to Plot','')
		DATAPLOTDONE=.FALSE.
		RETURN
	ENDIF
!***
!***Compute X TIC values
!***
	XMIN=1E10
	XMAX=-1E10
	DO IPLOT=1,NPLOT
		XMIN=MIN(XMIN,XPLOT(IPLOT))
		XMAX=MAX(XMAX,XPLOT(IPLOT))
	ENDDO
	XRANGE=XMAX-XMIN
	IF(XRANGE.GE.1.0) THEN
		EXPO=INT(LOG10(XRANGE))
	ELSE
		EXPO=INT(LOG10(XRANGE))-1
	ENDIF
	XNORMRANGE=XRANGE/10.0**EXPO
	IF(XNORMRANGE.LT.1.59) THEN
		XTICSTEP=0.2*10.0**EXPO
	ELSEIF(XNORMRANGE.LT.3.99) THEN
		XTICSTEP=0.5*10.0**EXPO
	ELSEIF(XNORMRANGE.LT.7.99) THEN
		XTICSTEP=1.0*10.0**EXPO
	ELSE
		XTICSTEP=2.0*10.0**EXPO
	ENDIF
	NDECX=2
	IF(XMIN.GE.0.0) THEN
		XTICS(1)=XMIN-MOD(XMIN,XTICSTEP)
		IF((XMIN-XTICS(1)).LT.0.1*XTICSTEP) XTICS(1)=XTICS(1)-XTICSTEP
	ELSE
		XTICS(1)=XMIN-MOD(XMIN,XTICSTEP)-XTICSTEP
		IF((XMIN-XTICS(1)).LT.0.1*XTICSTEP) XTICS(1)=XTICS(1)-XTICSTEP
	ENDIF
	DO NXTICS=2,10
		XTICS(NXTICS)=XTICS(NXTICS-1)+XTICSTEP
		IF(XTICS(NXTICS).GT.XMAX) EXIT
	ENDDO
	XMINTIC=XTICS(1)
	XMAXTIC=XTICS(NXTICS)
!***
!***Compute Y TIC values
!***
	YMIN=1D-3
	YMAX=1.1
	NYTICS=6
	YMINTIC=0.0
	YMAXTIC=1.1
	YTICSTEP=0.2
	DO ITIC=1,NYTICS
		YTICS(ITIC)=YMINTIC+(ITIC-1)*YTICSTEP
	ENDDO
	NDECY=1
!***
!***General Graphics Area Setup and Font Selection:
!***    (1) Set relative coordinates for page within graphics area and set page units to min, max tics
!***    (2) Set clipping region to graphics area, not page
!***    (3) Set character aspect adjustment factors
!***    (4) Set font number and spacing
!***
!	TYPE *,'TIC MARKS CALCULATED - SETTING UP GRAPHIC AREA'
	CALL IGrAreaClear()
	CALL IGrUnits(0.0,0.0,1.0,1.0)
	CALL IPgArea(0.15,0.15,0.95,0.95)
	CALL IPgUnitsXYZ(XMINTIC,YMINTIC,0.0,XMAXTIC,YMAXTIC,1.0)
	CALL IPgClipRectangle('G')
	CALL IGrCharSpacing('P')
	CALL IGrCharFont(1)
!***
!***Draw Axes and Axis Labels:
!***    (1) Set line width and character size
!***    (2) Draw X and Y axes
!***    (3) Set X-axis label position and draw centered label
!***    (4) Set Y-axis label position and draw centered label (90 degree rotation) 
!***
	CALL IGrLineWidth(NINT(RELTHICKAXIS),NINT(RELTHICKAXIS*15))
	CALL IGrColour('Black')
	CALL IGrCharSize(RELSIZEAXIS/RELASPECT,RELSIZEAXIS)
	CALL IPgAxes(XMINTIC,YMINTIC)
	CALL IPgXLabelPos(0.6)
	CALL IPgXLabel(TRIM(XLABEL),'C')
	CALL IPgYLabelPos(0.5)
	CALL IPgYLabelLeft(TRIM(YLABEL),'C9')
!***
!***Draw TICs and TIC Labels:
!***    (1) Set line width and character size
!***    (2) For X-axis, set number of decimals and scale position, give user TICs, and draw labels
!***    (2) For Y-axis, set number of decimals and scale position, give user TICs, and draw labels
!***
	CALL IGrLineWidth(NINT(RELTHICKAXIS),NINT(RELTHICKAXIS*10))
	CALL IGrColour('Black')
	CALL IGrCharSize(RELSIZETIC/RELASPECT,RELSIZETIC)
	CALL IPgDecimalPlaces(NDECX)
	CALL IPgXScalePos(0.25)
	CALL IPgXUserScale(XTICS,NXTICS)
	CALL IPgXScale('NI')
	CALL IPgDecimalPlaces(NDECY)
	CALL IPgYScalePos(1.0)
	CALL IPgYTickPos(XMINTIC,XMAXTIC)
	CALL IPgYUserScale(YTICS,NYTICS)
	CALL IPgYScaleLeft('NI')
!***
!***Draw Scatter Plot of Data:
!***(1) Filled black circles for each data point that is used
!***(2) Open red circles for each data point not used
!***(3) Red "bowties" for treatment means
!***
	DO IPLOT=1,NPLOT
		CALL IPgNewPlot(7,1,1,0,0)
		IF(CPLOT(IPLOT).EQ.0) THEN
			CALL IPgStyle(1,0,3,0,223,223,4)
			CALL IPgMarker(1,14,3.0)
			CALL IPgScatterPlot(XPLOT(IPLOT),YPLOT(IPLOT),1)
		ELSE
			CALL IPgStyle(1,0,3,0,31,31,4)
			CALL IPgMarker(1,41,3.0)
			CALL IPgScatterPlot(XPLOT(IPLOT),YPLOT(IPLOT),1)
		ENDIF
	ENDDO
	IF(REPDETECT) THEN
		CALL IPgNewPlot(7,1,1,0,0)
  		DO ITRT=1,NTRT
			IF(NREP(ITRT).LE.1) CYCLE
			TYPE *,ITRT,NREP(ITRT),XTRT(ITRT),YTRTFRAC(ITRT)
			CALL IPgStyle(1,0,3,0,31,31,4)
			CALL IPgMarker(1,20,3.0)
			type *,'calling ipgscatterplot',xtrt(itrt),ytrtfrac(itrt)
			CALL IPgScatterPlot(XTRT(ITRT),YTRTFRAC(ITRT),1)
  		ENDDO
	ENDIF
!***
!***Set plot as being done and return to calling routine 
!***
	DATAPLOTDONE=.TRUE.
!	TYPE *,'EXITING GRAPHDATA'
	RETURN
!***
!***Plot Predicted Line
!***    (1) Clip graph at page (axis limits)
!***    (2) Define line width, define nature of new plot, give style elements, and then draw line using XLINE, YLINE
!***
	ENTRY GRAPHLINE()
!	TYPE *,'IN GRAPHLINE',NLINE
	CALL IPgClipRectangle('P')
	CALL IPgNewPlot(6,1,NLINE,0,0)
	IF(CURVEFIT) THEN
		CALL IPgStyle(1,0,0,0,223,223,4)
	ELSE
		CALL IPgStyle(1,2,0,0,31,31,4)
	ENDIF
	CALL IPgXYPairs(XLINE,YLINE)
	RETURN

	ENTRY GRAPHPARMCL()
	TYPE *,'IN GRAPHPARMCL'
	CALL IPgClipRectangle('P')
	CALL IPgNewPlot(6,1,2,0,0)
	CALL IPgStyle(1,0,0,0,94,94,4)
	XCL(1)=PARMLCL(CLOPT)
	XCL(2)=PARMUCL(CLOPT)
	YCL(1)=(1-PTARGET(CLOPT))*PARMSOLUT(1)
	YCL(2)=(1-PTARGET(CLOPT))*PARMSOLUT(1)
	CALL IPgXYPairs(XCL,YCL)
	CALL IPgNewPlot(6,1,2,0,0)
	XCL(1)=PARMLCL(CLOPT)
	XCL(2)=PARMLCL(CLOPT)
	YCL(1)=(1-PTARGET(CLOPT))*PARMSOLUT(1)-0.02
	YCL(2)=(1-PTARGET(CLOPT))*PARMSOLUT(1)+0.02
	CALL IPgXYPairs(XCL,YCL)
	CALL IPgNewPlot(6,1,2,0,0)
	XCL(1)=PARMUCL(CLOPT)
	XCL(2)=PARMUCL(CLOPT)
	YCL(1)=(1-PTARGET(CLOPT))*PARMSOLUT(1)-0.02
	YCL(2)=(1-PTARGET(CLOPT))*PARMSOLUT(1)+0.02
	CALL IPgXYPairs(XCL,YCL) 
	RETURN

	ENTRY GRAPHLINECL()
	TYPE *,'IN GRAPHLINECL',NLINE
	CALL IPgClipRectangle('P')
	CALL IPgNewPlot(6,1,NLINE,0,0)
	IF(NPART.GE.2) THEN
		CALL IPgStyle(1,2,0,0,223,223,2)
	ELSE
		CALL IPgStyle(1,2,0,0,31,31,2)
	ENDIF
	RETURN

	END SUBROUTINE GRAPHDATA
