!****************************************************************
!***Routine for Cumulative Probabilities for Each Distribution***
!****************************************************************
	REAL*8 FUNCTION XPCONVERT(PARM)
	USE SHAREDVARS
	REAL*8 PARM(4)
	REAL*8 X50,XMODE,X0,X100,Z
	REAL*8 SD,SCALE,BETA,LAMBDA,FRACM,KAPPA,MU,SIG,XI,TEMP
	REAL*8 PI/3.141592653589793D0/
	REAL*8 NORMZP,NORMPZ
	EXTERNAL NORMZP,NORMPZ
!***
!***Logistic Distribution
!***
	IF(MODELOPT.EQ.1) THEN
          	X50=PARM(2)
          	SCALE=PARM(3)
          	XPCONVERT=X50-SCALE*LOG((1-PTARGET(CLOPT))/PTARGET(CLOPT))
!***
!***Normal/Gaussian Distribution
!***
	ELSEIF(MODELOPT.EQ.2) THEN
		X50=PARM(2)
		SD=PARM(3)
		XPCONVERT=X50+SD*NORMPZ(PTARGET(CLOPT))
!***
!***Rectangular/Uniform Distribution
!***
	ELSEIF(MODELOPT.EQ.3) THEN
		X50=PARM(2)
		SCALE=PARM(3)
		XPCONVERT=X50-0.5*SCALE+PTARGET(CLOPT)*SCALE
!***
!***Symmetric Triangular Distribution
!***
	ELSEIF(MODELOPT.EQ.4) THEN
		X50=PARM(2)
		SCALE=PARM(3)
		X0=X50-0.5*SCALE
		IF(PTARGET(CLOPT).LE.0.5D0) THEN
			XPCONVERT=X0+SCALE*SQRT(PTARGET(CLOPT)/2)
		ELSE
			XPCONVERT=X0+SCALE*(1-SQRT((1-PTARGET(CLOPT))/2))
		ENDIF
!***
!***GumbelR (Right Skewed) Distribution
!***
	ELSEIF(MODELOPT.EQ.5) THEN
		X50=PARM(2)
		BETA=PARM(3)
		XMODE=X50+BETA*LOG(-LOG(0.5))
		XPCONVERT=XMODE-BETA*LOG(-LOG(PTARGET(CLOPT)))
!***
!***GumbelL (Left Skewed) Distribution
!***
	ELSEIF(MODELOPT.EQ.6) THEN
		X50=PARM(2)
		BETA=PARM(3)
		XMODE=X50-BETA*LOG(-LOG(0.5))
		XPCONVERT=XMODE+BETA*LOG(-LOG(1-PTARGET(CLOPT)))
!***
!***Exponential Distribution with Threshold
!***
	ELSEIF(MODELOPT.EQ.7) THEN
		X50=PARM(2)
		LAMBDA=PARM(3)
		X0=X50+LOG(0.5)/LAMBDA
		XPCONVERT=X0-LOG(1-PTARGET(CLOPT))/LAMBDA
!***
!***Asymmetric Triangular Distribution
!***
	ELSEIF(MODELOPT.EQ.8) THEN
		X50=PARM(2)
		SCALE=PARM(3)
		FRACM=PARM(4)
		IF(FRACM.GT.0.5D0) THEN
			X0=X50-SQRT(0.5D0*SCALE**2*FRACM)
			X100=X0+SCALE
		ELSE
			X100=X50+SQRT(0.5D0*SCALE**2*(1-FRACM))
			X0=X100-SCALE
		ENDIF
		IF(PTARGET(CLOPT).LT.FRACM) THEN
			XPCONVERT=X0+SQRT(PTARGET(CLOPT)*SCALE**2*FRACM)
		ELSE
			XPCONVERT=X100-SQRT((1-PTARGET(CLOPT))*SCALE**2*(1-FRACM))
		ENDIF
!***
!***Skewed Logistic Distribution Sastry 
!***
	ELSEIF(MODELOPT.EQ.9) THEN
		X50=PARM(2)
		BETA=PARM(3)
		KAPPA=10D0**PARM(4)
		IF(0.5D0.LE.KAPPA/(KAPPA+1/KAPPA)) THEN
			XMODE=X50+BETA*KAPPA*LOG(2*KAPPA**2/(0.5*(1+KAPPA**2))-1)
		ELSE
			XMODE=X50-BETA/KAPPA*LOG(2*KAPPA**2/(0.5*(1+KAPPA**2)-KAPPA+1)-1)
		ENDIF
		IF(PTARGET(CLOPT).LE.KAPPA/(KAPPA+1/KAPPA)) THEN
			XPCONVERT=XMODE-BETA*KAPPA*LOG(2*KAPPA**2/(PTARGET(CLOPT)*(1+KAPPA**2))-1)
		ELSE
			XPCONVERT=XMODE+BETA/KAPPA*LOG(2*KAPPA**2/(PTARGET(CLOPT)*(1+KAPPA**2)-KAPPA+1)-1)
		ENDIF
!***
!***Skewed Logistic Distribution Aljarrah - POSITIVE SKEW ONLY FOR NOW - SIG>0 
!***
	ELSEIF(MODELOPT.EQ.10) THEN
		X50=PARM(2)
		SIG=PARM(3)
		XI=10D0**PARM(4)
		MU=X50-SIG*LOG((1-XI*LOG(1-0.5))**(1/XI)-1)
		XPCONVERT=MU+SIG*LOG((1-XI*LOG(1-PTARGET(CLOPT)))**(1/XI)-1)
!***
!***End Model Options
!***
	ENDIF
	RETURN
	END FUNCTION XPCONVERT


