     
!********************************
!***Basic Analysis of Data Set***
!********************************
	SUBROUTINE PARMCALC_NOCURVE()
	USE WINTERACTER
	USE RESOURCE
	USE SHAREDVARS
	INTEGER IROW,IDAT,ILINE,IPARM
	REAL*8 MODELCALC,XPCONVERT
	CHARACTER*1 CHAR
	EXTERNAL GETDATA,GRAPHDATA,GRAPHLINE,MODELCALC,OPTIMIZE,PARMCONF,GRAPHPARMCL,XPCONVERT
!***
!***Call Optimization Routine for Initial Information (this will not be a unique maximum likelihood due to parameter limits, but provides preliminary parameter solutions for further calcs)
!***
	IPHASE=0
	CLOPT=1
	DO IOPTPARM=1,NOPTPARM
		OPTPARMSEARCH(IOPTPARM,0)=PARMGUESS(IOPTPARM)
		TYPE "('IN NOCURVE - INITIAL SEARCH VECTOR',I3,G15.8)",IOPTPARM,OPTPARMSEARCH(IOPTPARM,0)
	ENDDO
	printflag2=.true.
	CALL OPTIMIZE()
	printflag2=.false.
	DO IOPTPARM=1,NOPTPARM
		TYPE "('IN CURVEFIT - FINAL SEARCH VECTOR',I3,2G15.8)",IOPTPARM,OPTPARMSEARCH(IOPTPARM,0),PARMSOLUT(IOPTPARM)
	ENDDO
	TYPE "('IN NOCURVE - FINAL FUNC',2G15.8)",FUNC(0),FUNCSOLUT
	!ACCEPT *,IGO
!***
!***Generate error descriptions and set dialog/grid colours for insufficient data 
!***
      NERROR=NERROR+1
      ERRORMESSAGE(NERROR)='Insufficent Partial Responses'
      CALL WDialogColour(IDF_MAIN_LOGLIKE_DOUBLE,RGB_RED) 
      CALL WDialogColour(IDF_MAIN_AIC_DOUBLE,RGB_RED) 
      CALL WGridColourColumn(IDF_MAIN_PARAMETERS_GRID,5,RGB_RED)
      CALL WGridColourRow(IDF_MAIN_ECP_GRID,4,RGB_RED)
      IF(OPTIMIZERROR(0).NE.0) THEN
         	NERROR=NERROR+1
          	ERRORMESSAGE(NERROR)='Parameter Convergence Incomplete'
      ENDIF
      DO IPARM=1,NPARM
          	IF(OPTIMIZERROR(IPARM).EQ.-1) THEN
          		NERROR=NERROR+1
          		WRITE(CHAR,'(I1)') IPARM
          		ERRORMESSAGE(NERROR)='Parameter '//CHAR//' at Minimum'
                 	CALL WGridColourCell(IDF_MAIN_PARAMETERS_GRID,4,IPARM,RGB_RED)
          	ELSEIF(OPTIMIZERROR(IPARM).EQ.1.AND.IPARM.NE.1) THEN
          		NERROR=NERROR+1
          		WRITE(CHAR,'(I1)') IPARM
          		ERRORMESSAGE(NERROR)='Parameter '//CHAR//' at Maximum'
                 	CALL WGridColourCell(IDF_MAIN_PARAMETERS_GRID,4,IPARM,RGB_RED)
          	ELSE
                 	CALL WGridColourCell(IDF_MAIN_PARAMETERS_GRID,4,IPARM,RGB_BLACK)
          	ENDIF
      ENDDO
!***
!***Output maximum likelihood estimates into dialog
!***Insert parameter estimates into parameter grid
!***
      CALL WDialogPutDouble(IDF_MAIN_LOGLIKE_DOUBLE,-FUNCSOLUT,'(F12.4)')
      AIC=2*NPARM+2*FUNCSOLUT
      CALL WDialogPutDouble(IDF_MAIN_AIC_DOUBLE,AIC,'(F12.4)')
	DO IPARM=1,NPARM
      	CALL WGridPutCellDouble(IDF_MAIN_PARAMETERS_GRID,4,IPARM,PARMSOLUT(IPARM))
	ENDDO
!***
!***Determine CLs for X50 and plot on graph  
!***
	TYPE *,'CALLING PARMCONF FOR X50 WITH CURVEFIT FALSE'
	CLOPT=1
	type *,clopt,xpconvert(parmsolut)
	CALL PARMCONF()
	CALL GRAPHPARMCL()
	!ACCEPT *,IGO
!***
!***Determine CLs for XP
!***
	TYPE *,'CALLING PARMCONF FOR XP WITH CURVEFIT FALSE'
	CLOPT=2
	ECPSOLUT=XPCONVERT(PARMSOLUT)
	TYPE *,'CLOPT=2,EXPSOLUT IS',clopt,ecpsolut
	CALL PARMCONF()
	CALL GRAPHPARMCL()
!***
!***Determine LCL for SCALE
!***
	TYPE *,'CALLING PARMCONF FOR PARAMETER 3 WITH CURVEFIT FALSE'
	CLOPT=3
	CALL PARMCONF()
!***
!***Specify alternative parameter estimates - Control survival (Parm1) is MLE est, but Parm2 (ECp) and Parm3 (Dispersion Parameter) are based on CLs
!***
	PARMALT(1)=PARMSOLUT(1)
	PARMALT(2)=(PARMLCL(1)+PARMUCL(1))/2
	PARMALT(3)=PARMUCL(3)/2  !2*PARMLCL(3)
	IF(NPARM.EQ.4) PARMALT(4)=PARMGUESS(4)
	ECPALT=(PARMLCL(2)+PARMUCL(2))/2
	TYPE "('PARMALT',4G15.6)",PARMALT
!***
!***Compute and Plot Predicted Line 
!***
  	NLINE=100
	TYPE *,'PLOTTING APPROXIMATE LINE'
    	DO ILINE=1,NLINE
      	XLINE(ILINE)=XMINTIC+(XMAXTIC-XMINTIC)*(ILINE-1.0)/(NLINE-1.0)
      	YLINE(ILINE)=MODELCALC(DBLE(XLINE(ILINE)),PARMALT)
    	END DO
    	CALL GRAPHLINE()
!***
!***Put X50 and XP into ECP grid with CLs
!***
      IF(XTRANSFORM.EQ.3) THEN
            CALL WGridPutCellDouble(IDF_MAIN_ECP_GRID,2,4,PARMALT(2))
          	CALL WGridPutCellDouble(IDF_MAIN_ECP_GRID,2,2,PARMLCL(1))
          	CALL WGridPutCellDouble(IDF_MAIN_ECP_GRID,2,3,PARMUCL(1))
            CALL WGridPutCellDouble(IDF_MAIN_ECP_GRID,4,4,ECPALT)
          	CALL WGridPutCellDouble(IDF_MAIN_ECP_GRID,4,2,PARMLCL(2))
          	CALL WGridPutCellDouble(IDF_MAIN_ECP_GRID,4,3,PARMUCL(2))
            CALL WGridPutCellDouble(IDF_MAIN_ECP_GRID,1,4,LOG10(PARMALT(2)))
         	CALL WGridPutCellDouble(IDF_MAIN_ECP_GRID,1,2,LOG10(PARMLCL(1)))
          	CALL WGridPutCellDouble(IDF_MAIN_ECP_GRID,1,3,LOG10(PARMUCL(1)))
            CALL WGridPutCellDouble(IDF_MAIN_ECP_GRID,3,4,LOG10(ECPALT))
          	CALL WGridPutCellDouble(IDF_MAIN_ECP_GRID,3,2,LOG10(PARMLCL(2)))
          	CALL WGridPutCellDouble(IDF_MAIN_ECP_GRID,3,3,LOG10(PARMUCL(2)))
      ELSE
            CALL WGridPutCellDouble(IDF_MAIN_ECP_GRID,1,4,PARMALT(2))
          	CALL WGridPutCellDouble(IDF_MAIN_ECP_GRID,1,2,PARMLCL(1))
          	CALL WGridPutCellDouble(IDF_MAIN_ECP_GRID,1,3,PARMUCL(1))
            CALL WGridPutCellDouble(IDF_MAIN_ECP_GRID,3,4,ECPALT)
          	CALL WGridPutCellDouble(IDF_MAIN_ECP_GRID,3,2,PARMLCL(2))
          	CALL WGridPutCellDouble(IDF_MAIN_ECP_GRID,3,3,PARMUCL(2))
            CALL WGridPutCellDouble(IDF_MAIN_ECP_GRID,2,4,10D0**PARMALT(2))
          	CALL WGridPutCellDouble(IDF_MAIN_ECP_GRID,2,2,10D0**PARMLCL(1))
          	CALL WGridPutCellDouble(IDF_MAIN_ECP_GRID,2,3,10D0**PARMUCL(1))
            CALL WGridPutCellDouble(IDF_MAIN_ECP_GRID,4,4,10D0**ECPALT)
          	CALL WGridPutCellDouble(IDF_MAIN_ECP_GRID,4,2,10D0**PARMLCL(2))
          	CALL WGridPutCellDouble(IDF_MAIN_ECP_GRID,4,3,10D0**PARMUCL(2))
      ENDIF

	RETURN

	END SUBROUTINE PARMCALC_NOCURVE
 
