     
!********************************
!***Basic Analysis of Data Set***
!********************************
	SUBROUTINE PARMCALC_CURVEFIT()
	USE WINTERACTER
	USE RESOURCE
	USE SHAREDVARS
	INTEGER IROW,IDAT,ILINE,IPARM
	REAL*8 MODELCALC,XPCONVERT,FUNCCALC
	CHARACTER*1 CHAR
	EXTERNAL GETDATA,GRAPHDATA,GRAPHLINE,MODELCALC,PARMCONF,GRAPHPARMCL,XPCONVERT,FUNCCALC
	IPHASE=0
	CLOPT=1
!***
!***Call Optimization Routine to estimate all parameters (X50).
!***
	DO IOPTPARM=1,NOPTPARM
		OPTPARMSEARCH(IOPTPARM,0)=PARMGUESS(IOPTPARM)
		TYPE "('IN CURVEFIT - INITIAL SEARCH VECTOR',I3,G15.8)",IOPTPARM,OPTPARMSEARCH(IOPTPARM,0)
	ENDDO
	PRINTFLAG=.TRUE.
	TYPE *,'ABOUT TO CALL OPTIMIZE, INITIAL FUNCTION',FUNCCALC(PARMGUESS)
	TYPE *,'ABOUT TO CALL OPTIMIZE, INITIAL FUNCTION',FUNCCALC(OPTPARMSEARCH(1,0))
	CALL OPTIMIZE()
	PRINTFLAG=.FALSE.
	DO IOPTPARM=1,NOPTPARM
		TYPE "('IN CURVEFIT - FINAL SEARCH VECTOR',I3,2G15.8)",IOPTPARM,OPTPARMSEARCH(IOPTPARM,0),PARMSOLUT(IOPTPARM)
	ENDDO
	TYPE "('IN CURVEFIT - FINAL FUNC',2G15.8)",FUNC(0),FUNCSOLUT
!***
!***Generate error messages and set dialog/grid colours for errors
!***
      IF(OPTIMIZERROR(0).NE.0) THEN
         	NERROR=NERROR+1
          	ERRORMESSAGE(NERROR)='Parameter Convergence Incomplete'
          	CALL WDialogColour(IDF_MAIN_LOGLIKE_DOUBLE,RGB_RED) 
          	CALL WDialogColour(IDF_MAIN_AIC_DOUBLE,RGB_RED) 
            CALL WGridColourColumn(IDF_MAIN_PARAMETERS_GRID,5,RGB_RED)
      ELSE
          	CALL WDialogColour(IDF_MAIN_LOGLIKE_DOUBLE,RGB_BLACK) 
          	CALL WDialogColour(IDF_MAIN_AIC_DOUBLE,RGB_BLACK) 
            CALL WGridColourColumn(IDF_MAIN_PARAMETERS_GRID,5,RGB_BLACK)
      ENDIF
      DO IPARM=1,NPARM
          	IF(OPTIMIZERROR(IPARM).EQ.-1) THEN
          		NERROR=NERROR+1
          		WRITE(CHAR,'(I1)') IPARM
          		ERRORMESSAGE(NERROR)='Parameter '//CHAR//' at Minimum'
                 	CALL WGridColourCell(IDF_MAIN_PARAMETERS_GRID,5,IPARM,RGB_RED)
          	ELSEIF(OPTIMIZERROR(IPARM).EQ.1.AND.IPARM.NE.1) THEN
          		NERROR=NERROR+1
          		WRITE(CHAR,'(I1)') IPARM
          		ERRORMESSAGE(NERROR)='Parameter '//CHAR//' at Maximum'
                 	CALL WGridColourCell(IDF_MAIN_PARAMETERS_GRID,5,IPARM,RGB_RED)
          	ELSE
                 	CALL WGridColourCell(IDF_MAIN_PARAMETERS_GRID,5,IPARM,RGB_BLACK)
          	ENDIF
      ENDDO
!***
!***Insert maximum likelihood statistic and AIC into dialog
!***Insert parameter estimates into parameter grid
!***
      CALL WDialogPutDouble(IDF_MAIN_LOGLIKE_DOUBLE,-FUNCSOLUT,'(F12.4)')
      AIC=2*NPARM+2*FUNCSOLUT
      CALL WDialogPutDouble(IDF_MAIN_AIC_DOUBLE,AIC,'(F12.4)')
      DO IPARM=1,NPARM
           	CALL WGridPutCellDouble(IDF_MAIN_PARAMETERS_GRID,4,IPARM,PARMSOLUT(IPARM))
      ENDDO
!***
!***Compute and Plot Predicted Line 
!***
  	NLINE=100
	TYPE *,'PLOTTING PREDICTED LINE'
    	DO ILINE=1,NLINE
      	XLINE(ILINE)=XMINTIC+(XMAXTIC-XMINTIC)*(ILINE-1.0)/(NLINE-1.0)
      	YLINE(ILINE)=MODELCALC(DBLE(XLINE(ILINE)),PARMSOLUT)
    	END DO
    	CALL GRAPHLINE()
	!ACCEPT *,IGO
!***
!***Determine CLs for X50 and plot on graph  
!***
	TYPE *,'CALLING PARMCONF FOR X50 WITH CURVEFIT TRUE'
	CLOPT=1
	type *,clopt,xpconvert(parmsolut)
	CALL PARMCONF()
	CALL GRAPHPARMCL()
	!ACCEPT *,IGO
!***
!***Determine CLs for XP
!***
	TYPE *,'CALLING PARMCONF FOR XP WITH CURVEFIT TRUE'
	CLOPT=2
	ECPSOLUT=XPCONVERT(PARMSOLUT)
	type *,clopt,ecpsolut
	CALL PARMCONF()
	CALL GRAPHPARMCL()
!***
!***Put X50 and XP into ECP grid with CLs
!***
      IF(XTRANSFORM.EQ.3) THEN
            CALL WGridPutCellDouble(IDF_MAIN_ECP_GRID,2,1,PARMSOLUT(2))
          	CALL WGridPutCellDouble(IDF_MAIN_ECP_GRID,2,2,PARMLCL(1))
          	CALL WGridPutCellDouble(IDF_MAIN_ECP_GRID,2,3,PARMUCL(1))
            CALL WGridPutCellDouble(IDF_MAIN_ECP_GRID,4,1,ECPSOLUT)
          	CALL WGridPutCellDouble(IDF_MAIN_ECP_GRID,4,2,PARMLCL(2))
          	CALL WGridPutCellDouble(IDF_MAIN_ECP_GRID,4,3,PARMUCL(2))
            CALL WGridPutCellDouble(IDF_MAIN_ECP_GRID,1,1,LOG10(PARMSOLUT(2)))
         	CALL WGridPutCellDouble(IDF_MAIN_ECP_GRID,1,2,LOG10(PARMLCL(1)))
          	CALL WGridPutCellDouble(IDF_MAIN_ECP_GRID,1,3,LOG10(PARMUCL(1)))
            CALL WGridPutCellDouble(IDF_MAIN_ECP_GRID,3,1,LOG10(ECPSOLUT))
          	CALL WGridPutCellDouble(IDF_MAIN_ECP_GRID,3,2,LOG10(PARMLCL(2)))
          	CALL WGridPutCellDouble(IDF_MAIN_ECP_GRID,3,3,LOG10(PARMUCL(2)))
      ELSE
            CALL WGridPutCellDouble(IDF_MAIN_ECP_GRID,1,1,PARMSOLUT(2))
          	CALL WGridPutCellDouble(IDF_MAIN_ECP_GRID,1,2,PARMLCL(1))
          	CALL WGridPutCellDouble(IDF_MAIN_ECP_GRID,1,3,PARMUCL(1))
            CALL WGridPutCellDouble(IDF_MAIN_ECP_GRID,3,1,ECPSOLUT)
          	CALL WGridPutCellDouble(IDF_MAIN_ECP_GRID,3,2,PARMLCL(2))
          	CALL WGridPutCellDouble(IDF_MAIN_ECP_GRID,3,3,PARMUCL(2))
            CALL WGridPutCellDouble(IDF_MAIN_ECP_GRID,2,1,10D0**PARMSOLUT(2))
          	CALL WGridPutCellDouble(IDF_MAIN_ECP_GRID,2,2,10D0**PARMLCL(1))
          	CALL WGridPutCellDouble(IDF_MAIN_ECP_GRID,2,3,10D0**PARMUCL(1))
            CALL WGridPutCellDouble(IDF_MAIN_ECP_GRID,4,1,10D0**ECPSOLUT)
          	CALL WGridPutCellDouble(IDF_MAIN_ECP_GRID,4,2,10D0**PARMLCL(2))
          	CALL WGridPutCellDouble(IDF_MAIN_ECP_GRID,4,3,10D0**PARMUCL(2))
      ENDIF

	RETURN

	END SUBROUTINE PARMCALC_CURVEFIT 
