     
!********************************
!***Basic Analysis of Data Set***
!********************************
	SUBROUTINE PARMCALC()
	USE WINTERACTER
	USE RESOURCE
	USE SHAREDVARS
	INTEGER IROW,IPARM
	EXTERNAL GETDATA,GRAPHDATA,PARMCALC_CURVEFIT!,PARMCALC_NOCURVE
	TYPE *,'IN PARMCALC'
!***
!***Set flags for computational phase
!***
	IPHASE=0
	FIXLINE=0
	FIXPARMLIMID=0
	FIXPARMCLID=0
	NPARM=NPARMMOD(MODELOPT)
	NOPTPARM=NPARM
	DO IPARM=1,NOPTPARM		
		OPTPARMID(IPARM)=IPARM
		TYPE *,'IN PARMCALC - OPTPARMID',IPARM,OPTPARMID(IPARM),PARMGUESS(IPARM)
	ENDDO
!***
!***Initialize error variables
!***
	NERROR=0
	ERRORMESSAGE(1)='None'
	DO IROW=2,10
		ERRORMESSAGE(IROW)=''
	ENDDO
!***
!***Update data and graph
!***If data numbers are below absolute minimums, stop analysis
!***
	CALL GETDATA()
	CALL GRAPHDATA()
	DATAPLOTDONE=.TRUE.
	IF(NTRT.LT.NPARM) THEN
		Call WMessageBox(OKOnly,StopIcon,CommonOK,'Insufficient Data for Analysis','')
		RETURN
	ENDIF
!***
!***Update parameter guesses, etc. in case user changed them; stop analysis if info not available
!***
	RESETERROR=InfoError(1)
	DO IPARM=1,NPARM
		CALL WGridGetCellDouble(IDF_MAIN_PARAMETERS_GRID,1,IPARM,PARMGUESS(IPARM))
		CALL WGridGetCellDouble(IDF_MAIN_PARAMETERS_GRID,2,IPARM,PARMMIN(IPARM))
		CALL WGridGetCellDouble(IDF_MAIN_PARAMETERS_GRID,3,IPARM,PARMMAX(IPARM))
	ENDDO
	CALL WDialogGetInteger(IDF_MAIN_NCTRL_INTEGER,NCTRL)
	CALL WDialogGetInteger(IDF_MAIN_NPART_INTEGER,NPART)
	CALL WDialogGetInteger(IDF_MAIN_NFULL_INTEGER,NFULL)
	IF(InfoError(1).EQ.1010) THEN
		Call WMessageBox(OKOnly,StopIcon,CommonOK,'Parameterization Options Missing','')
		RETURN
	ENDIF
!***
!***Alternative actions depending on NPART 
!***
	IF(NPART.EQ.0.OR.(NPART.EQ.1.AND.MODELOPT.GE.8)) THEN
		CALL WMessageBox(OKOnly,StopIcon,CommonOK,'Insufficient Data for Analysis','')
		RETURN
	ELSEIF((NPART.EQ.1.AND.MODELOPT.LT.8).OR.(NPART.EQ.2.AND.MODELOPT.GE.8)) THEN
		CURVEFIT=.FALSE.
		CALL WMessageBox(OKOnly,StopIcon,CommonOK,'Insufficient Data for MLE; Midpoint of CLs Will Be Used','')
		CALL PARMCALC_NOCURVE
	ELSE
		CURVEFIT=.TRUE.
		CALL PARMCALC_CURVEFIT
	ENDIF
!***
!***Set completion flags, load field with error messages, and enable output options
!***
	PARMESTDONE=.TRUE.
	PARMCONFDONE=.TRUE.
	Call WDialogPutMenu(IDF_MAIN_ERRORINFO_MENU,ERRORMESSAGE,MAX(1,NERROR),1)
	Call WMenuSetState(ID_OUTPUT_PRINTEROUTPUT,ItemEnabled,1)
	Call WMenuSetState(ID_OUTPUT_COPYGRAPH,ItemEnabled,1)
	Call WMenuSetState(ID_OUTPUT_PREDLINEPTS,ItemEnabled,1)
	Call WMenuSetState(ID_OUTPUT_CSVFILE,ItemEnabled,1)
	!ACCEPT *,IGO
	RETURN

	END SUBROUTINE PARMCALC 
