!****************************************************************************
!***Routine for Derivatives of Minimization Function by Analytical Methods
!***Called with reduced set of parameters being optimized
!***Sets full set of parameters for call to DMODELCALC
!***Sets derivatives for just reduced set
!****************************************************************************
	SUBROUTINE DFUNCCALC(OPTPARMVAL)
	USE SHAREDVARS
	REAL*8 FUNCCALC,OPTPARMVAL(4),FUNC0,FUNCL,FUNCH,FUNCLL,FUNCLH,FUNCHL,FUNCHH,DELTAFAC/1D-5/,DELTA1,DELTA2
	INTEGER IDAT,IOPTPARM,JOPTPARM,IPARM
!***Reset derivative values
	DO IOPTPARM=1,4
		DFUNC(IOPTPARM)=0D0
		DO JOPTPARM=1,4
			DFUNC2(IOPTPARM,JOPTPARM)=0D0
		END DO
	END DO
!***Compute first and second derivatives of minimization function numerically based on calls to FUNCCALC 
!***Generation is only for reduced vectors and matrices for parameters to be optimized 
	DO IOPTPARM=1,NOPTPARM
		DELTA1=DELTAFAC*OPTPARMVAL(IOPTPARM)
		FUNC0=FUNCCALC(OPTPARMVAL)
		OPTPARMVAL(IOPTPARM)=OPTPARMVAL(IOPTPARM)-DELTA1
		FUNCL=FUNCCALC(OPTPARMVAL)
		OPTPARMVAL(IOPTPARM)=OPTPARMVAL(IOPTPARM)+2*DELTA1
		FUNCH=FUNCCALC(OPTPARMVAL)
		OPTPARMVAL(IOPTPARM)=OPTPARMVAL(IOPTPARM)-DELTA1
		DFUNC(IOPTPARM)=(FUNCH-FUNCL)/DELTA1/2
		DFUNC2(IOPTPARM,IOPTPARM)=(FUNCH+FUNCL-2*FUNC0)/(DELTA1)**2
	END DO
	DO IOPTPARM=1,NOPTPARM-1
	DO JOPTPARM=IOPTPARM+1,NOPTPARM
		DELTA1=DELTAFAC*OPTPARMVAL(IOPTPARM)
		DELTA2=DELTAFAC*OPTPARMVAL(JOPTPARM)
		OPTPARMVAL(IOPTPARM)=OPTPARMVAL(IOPTPARM)-DELTA1
		OPTPARMVAL(JOPTPARM)=OPTPARMVAL(JOPTPARM)-DELTA2
		FUNCLL=FUNCCALC(OPTPARMVAL)
		OPTPARMVAL(IOPTPARM)=OPTPARMVAL(IOPTPARM)+2*DELTA1
		FUNCHL=FUNCCALC(OPTPARMVAL)
		OPTPARMVAL(JOPTPARM)=OPTPARMVAL(JOPTPARM)+2*DELTA2
		FUNCHH=FUNCCALC(OPTPARMVAL)
		OPTPARMVAL(IOPTPARM)=OPTPARMVAL(IOPTPARM)-2*DELTA1
		FUNCLH=FUNCCALC(OPTPARMVAL)
		OPTPARMVAL(IOPTPARM)=OPTPARMVAL(IOPTPARM)+DELTA1
		OPTPARMVAL(JOPTPARM)=OPTPARMVAL(JOPTPARM)-DELTA2
		DFUNC2(IOPTPARM,JOPTPARM)=(FUNCHH+FUNCLL-FUNCLH-FUNCHL)/DELTA1/DELTA2/4
		DFUNC2(JOPTPARM,IOPTPARM)=DFUNC2(IOPTPARM,JOPTPARM)
	END DO
	END DO
	RETURN
	END SUBROUTINE DFUNCCALC


