!**********************************************
!***Various HardCopy and File Output Options***
!**********************************************
	SUBROUTINE OUTPUTRESULTS()
	USE WINTERACTER
	USE IONTOXMODEL_INTERFACEVARS
	USE IONTOXMODEL_MODELVARS
	USE RESOURCE
	REAL BTOP
    EXTERNAL PRINTHEADER,PRINTGRAPH,PRINTPARAM,PRINTPARAMOPT,PRINTCLCALCS,PRINTDATA,GRAPHDATA,GRAPHLINE
!Initialize Hardcopy Output and Page Format Options
	ELLIPSEFLAG=1
	CALL IGrInit('H')
	CALL IGrHardCopySelect(1,10)
	CALL IGrHardCopyOptions(1,468)
	CALL IGrHardCopyOptions(2,684)
	CALL IGrHardCopyOptions(3,72)
	CALL IGrHardCopyOptions(4,72)
	CALL IGrHardCopyOptions(5,0)
	CALL IGrHardCopy()
!Call Routines for Each Section of Output
	CALL PRINTHEADER(BTOP)
	CALL PRINTGRAPH(BTOP)
	CALL PRINTPARAM(BTOP)
	CALL PRINTPARAMOPT(BTOP)
	CALL IGrEndPage()
	CALL PRINTHEADER(BTOP)
	CALL PRINTCLCALCS(BTOP)
	CALL PRINTDATA(BTOP)
!Return to Screen Output
	CALL IGrHardCopy('S')
	ELLIPSEFLAG=0
	IF(ANALYSISDONE) THEN 
		CALL GRAPHDATA()
		CALL GRAPHLINE()
	ENDIF
	RETURN
	END SUBROUTINE OUTPUTRESULTS

	SUBROUTINE PRINTHEADER(BTOP)
	USE WINTERACTER
	USE IONTOXMODEL_INTERFACEVARS
	USE IONTOXMODEL_MODELVARS
	USE RESOURCE
	CHARACTER*10 DATE,TIME
	REAL BTOP,BWID,BHGT
	INTEGER NCHAR
	CALL WDialogGetString(IDF_MAIN_OUTPUTHEADER_STRING,HEADERSTRING0)
	CALL WDialogGetMenu(IDF_MAIN_SPECIES_MENU,IGO,SPECNAME)
	HEADERSTRING=TRIM(HEADERSTRING0)//'      '//TRIM(SPECNAME)//'      '//TRIM(VARNAME)//'      '//TRIM(MODNAME(MODOPT))
	BTOP=9.5
!Define Graphics Area and Units for Footnotes; Outline Area
	BWID=6.5
	BHGT=0.3
	CALL IGrArea(0.0,0.0,BWID/6.5,BHGT/9.5)
	CALL IGrUnits(0.,0.,1.,1.)
	CALL IGrLineWidth(1,10)
	CALL IGrBorder()
!Define Character Size for Footnotes
	CALL WGrTextOptions(GrTextRatio,RatioHeight)
	CALL WGrTextFont(FFHelvetica,HEIGHT=0.12/BHGT)
!Right Footnote - Analysis Name
	CALL WGrTextOrientation(AlignRight)
	CALL WGrTextString(0.98,0.5,"WQC TotIon vs CaConc Regr")
!Left Footnote - Date/Time
	CALL DATE_AND_TIME(DATE,TIME)
	CALL WGrTextOrientation(AlignLeft)
	CALL WGrTextString(0.02,0.5,"Analysis Date:  "//DATE(5:6)//"/"//DATE(7:8)//"/"//DATE(1:4)//"  "//TIME(1:2)//":"//TIME(3:4))
!Define Graphics Area and Units for Header; Outline Area 
	BWID=6.5
	BHGT=0.5
	CALL IGrArea(0.0,(BTOP-BHGT)/9.5,BWID/6.5,BTOP/9.5)
	CALL IGrUnits(0.,0.,1.,1.)
	CALL IGrLineWidth(1,10)
	CALL IGrBorder()
!Read Desired Header; Define Font; Send to Output
	NCHAR=LEN_TRIM(HEADERSTRING)
	CALL WGrTextFont(FFHelvetica,ISTYLE=FSBold,HEIGHT=0.2/BHGT)
	CALL WGrTextOrientation(AlignCentre)
	CALL WGrTextString(0.5,0.5,HEADERSTRING(1:NCHAR))
!Update BTOP for Next Output Section
	BTOP=BTOP-BHGT-0.2
	RETURN
	END SUBROUTINE PRINTHEADER

	SUBROUTINE PRINTGRAPH(BTOP)
	USE WINTERACTER
	USE IONTOXMODEL_INTERFACEVARS
	USE IONTOXMODEL_MODELVARS
	USE RESOURCE
	REAL BTOP,BHGT,BWID
    EXTERNAL GRAPHDATA,GRAPHLINE
!Define Graphics Area and Units for Data/Model Plot; Outline Area 
	BHGT=4.33
	BWID=6.5
	CALL IGrArea(0.0,(BTOP-BHGT)/9.5,BWID/6.5,BTOP/9.5)
	CALL IGrUnits(0.,0.,1.,1.)
	CALL IGrLineWidth(1,10)
	CALL IGrBorder()
!Call Graphics Routines 
	CALL GRAPHDATA()
	CALL GRAPHLINE()
!Update BTOP for Next Output Section
	BTOP=BTOP-BHGT-0.2
	RETURN
	END SUBROUTINE PRINTGRAPH

	SUBROUTINE PRINTPARAM(BTOP)
	USE WINTERACTER
	USE IONTOXMODEL_INTERFACEVARS
	USE IONTOXMODEL_MODELVARS
	USE RESOURCE
	CHARACTER(LEN=9) HEADING(8) /"PName   ","   Guess","   Delta","    PMin","    PMax","    PEst","  95%LCL","  95%UCL"/
	REAL BTOP,BHGT,BWID,COLLOC(8)/0.25,1.60,2.30,3.00,3.70,4.55,5.40,6.25/
	INTEGER IPARM,ICOL
!Define Graphics Area and Units for Parameter Grid; Outline Area 
	BHGT=0.65+4*0.25 !(0.65 inches for headings and margins; 0.25 inches per parameter)
	BWID=6.5
	CALL IGrArea(0.0,(BTOP-BHGT)/9.5,BWID/6.5,BTOP/9.5)
	CALL IGrUnits(0.0,-BHGT,BWID,0.0)  !Units are in inches rather than fraction
	CALL IGrLineWidth(1,10)
	CALL IGrBorder()
!Define Font Options and Write Section Heading
	CALL WGrTextOptions(GrTextRatio,RatioHeight)
	CALL WGrTextFont(FFHelvetica,ISTYLE=FSBold,HEIGHT=0.18/BHGT)
	CALL WGrTextOrientation(AlignCentre)
	CALL WGrTextString(3.25,-0.20,"Parameter Summary")
!Write First Column - Heading and Parameter Names
	CALL WGrTextFont(FFHelvetica,ISTYLE=0,HEIGHT=0.16/BHGT)
	CALL WGrTextOrientation(AlignLeft)
	CALL WGrTextString(COLLOC(1),-0.45,HEADING(1))
	DO IPARM=1,NPARM
		CALL IGrCharOut(COLLOC(1),-0.45-IPARM*0.25,PARMNAME(IPARM,MODOPT))
	ENDDO
!Enter AICs on Section Heading Line
	CALL WGrTextOrientation(AlignRight)
	CALL WGrTextString(4.7,-0.20,'ModelAIC:')
	CALL WGrTextDouble(5.2,-0.20,AIC,'(F8.2)')
	CALL WGrTextString(5.8,-0.20,'NullAIC:')
	CALL WGrTextDouble(6.3,-0.20,AICNULL,'(F8.2)')
!Write Other Columns - Column Headings, Then Parameter Values and CLs
	DO ICOL=2,8
		CALL WGrTextString(COLLOC(ICOL)+0.03,-0.45,HEADING(ICOL))
	ENDDO
	DO IPARM=1,NPARM
		CALL WGrTextDouble(COLLOC(2),-0.45-IPARM*0.25,PARMGUESS(IPARM),'(F8.4)')
		CALL WGrTextDouble(COLLOC(3),-0.45-IPARM*0.25,PARMDELTA(IPARM),'(F8.4)')
		CALL WGrTextDouble(COLLOC(4),-0.45-IPARM*0.25,PARMMIN(IPARM),'(F8.4)')
		CALL WGrTextDouble(COLLOC(5),-0.45-IPARM*0.25,PARMMAX(IPARM),'(F8.4)')
		CALL WGrTextDouble(COLLOC(6),-0.45-IPARM*0.25,PARMSOLUT(IPARM),'(F10.5)')
		IF(CLFLAGLCL(IPARM,0).EQ.1) THEN
			CALL IGrColour('Blue')
		ELSEIF(CLFLAGLCL(IPARM,0).EQ.-1) THEN
			CALL IGrColour('Red')
		ELSE
			CALL IGrColour('Black')
		ENDIF
		CALL WGrTextDouble(COLLOC(7),-0.45-IPARM*0.25,PARMLCL(IPARM),'(F10.5)')
		IF(CLFLAGUCL(IPARM,0).EQ.1) THEN
			CALL IGrColour('Blue')
		ELSEIF(CLFLAGUCL(IPARM,0).EQ.-1) THEN
			CALL IGrColour('Red')
		ELSE
			CALL IGrColour('Black')
		ENDIF
		CALL WGrTextDouble(COLLOC(8),-0.45-IPARM*0.25,PARMUCL(IPARM),'(F10.5)')
		CALL IGrColour('Black')
	ENDDO
!Update BTOP for Next Output Section
	BTOP=BTOP-BHGT-0.2
	RETURN
	END SUBROUTINE PRINTPARAM

	SUBROUTINE PRINTPARAMOPT(BTOP)
	USE WINTERACTER
	USE IONTOXMODEL_INTERFACEVARS
	USE IONTOXMODEL_MODELVARS
	USE RESOURCE
	REAL BTOP,BHGT,BWID,COLLOC(6)/0.2,1.10,2.30,3.50,4.70,5.90/
	REAL COLLOC2(11)/0.2,0.75,1.40,2.10,2.60,3.25,3.75,4.40,4.90,5.55,6.05/
	INTEGER IHISTSAVE,IPARM
!Define Graphics Area and Units for Parameter Grid; Outline Area 
	BHGT=0.65+5*0.25 !(0.65 inches for headings and margins; 0.25 inches per row)
	BWID=6.5
	CALL IGrArea(0.0,(BTOP-BHGT)/9.5,BWID/6.5,BTOP/9.5)
	CALL IGrUnits(0.0,-BHGT,BWID,0.0)
	CALL IGrLineWidth(1,10)
	CALL IGrBorder()
!Define Font Options and Write Section Heading
	CALL WGrTextOptions(GrTextRatio,RatioHeight)
	CALL WGrTextFont(FFHelvetica,ISTYLE=FSBold,HEIGHT=0.18/BHGT)
	CALL WGrTextOrientation(AlignCentre)
	CALL WGrTextString(3.25,-0.20,"Parameter Optimization History")
!Write Column Headings 
	CALL WGrTextFont(FFHelvetica,ISTYLE=0,HEIGHT=0.16/BHGT)
	CALL WGrTextOrientation(AlignCentre)
	CALL WGrTextString(COLLOC(1),-0.45,'Iter')
	CALL WGrTextString(COLLOC(2),-0.45,'LogLike')
	DO IPARM=1,NPARM
		CALL WGrTextString(COLLOC(IPARM+2),-0.45,PARMNAME(IPARM,MODOPT))
	ENDDO
!Write Parameter Optimization History - 5 rows
	DO IHISTSAVE=1,5
		CALL WGrTextInteger(COLLOC2(1),-0.45-0.25*IHISTSAVE,HISTITERSAVE(IHISTSAVE),3)
		CALL WGrTextDouble(COLLOC2(2),-0.45-0.25*IHISTSAVE,HISTFUNCSAVE(IHISTSAVE,1),'(F10.3)')
		CALL WGrTextDouble(COLLOC2(3),-0.45-0.25*IHISTSAVE,HISTFUNCSAVE(IHISTSAVE,2),'(F10.3)')
		DO IPARM=1,NPARM
			CALL WGrTextDouble(COLLOC2(2*IPARM+2),-0.45-0.25*IHISTSAVE,HISTPARMSAVE(IHISTSAVE,IPARM,1),'(F8.4)')
			CALL WGrTextDouble(COLLOC2(2*IPARM+3),-0.45-0.25*IHISTSAVE,HISTPARMSAVE(IHISTSAVE,IPARM,2),'(F8.4)')
		ENDDO
	ENDDO
	BTOP=BTOP-BHGT-0.2
	END SUBROUTINE PRINTPARAMOPT

	SUBROUTINE PRINTCLCALCS(BTOP)
	USE WINTERACTER
	USE IONTOXMODEL_INTERFACEVARS
	USE IONTOXMODEL_MODELVARS
	USE RESOURCE
	REAL BTOP,BHGT,BWID,COLLOC(11)/2.4,3.15,3.9,4.5,5.1,5.7,5.92,6.04,6.16,6.28,6.40/
	INTEGER ICOL,IDIR,IPARM,ICOL1,ICOL2,ICOL3,IERR
	CHARACTER(LEN=8) NUMBER
	CHARACTER(LEN=10) COLNAME(7)/'logLike@CL','   CLValue','  logLCMax','  logSlope','  logCaBrk','    StdDev','ErrorFlags'/
	CHARACTER(LEN=3) CLTYPE(2)/'LCL','UCL'/
!Define Graphics Area and Units for Parameter Grid; Outline Area 
	BWID=6.5
	BHGT=2.4
	type *,'IN PRINTCLCALCS, BTOP IS:',BTOP,BWID,BHGT
	CALL IGrArea(0.0,(BTOP-BHGT)/9.5,BWID/6.5,BTOP/9.5)
	CALL IGrUnits(0.0,-BHGT,BWID,0.0)  !Units are in inches rather than fraction
	CALL IGrLineWidth(1,10)
	CALL IGrBorder()
!Define Font Options and Write Section Heading
	CALL WGrTextOptions(GrTextRatio,RatioHeight)
	CALL WGrTextFont(FFHelvetica,ISTYLE=FSBold,HEIGHT=0.18/BHGT)
	CALL WGrTextOrientation(AlignCentre)
	CALL WGrTextString(3.25,-0.2,"Confidence Limits Calculations")
	CALL WGrTextFont(FFHelvetica,ISTYLE=0,HEIGHT=0.16/BHGT)
	WRITE(UNIT=NUMBER,FMT='(F8.3)') CLLIKETARGET
	CALL WGrTextOrientation(AlignLeft)
	CALL WGrTextString(0.3,-0.45,"(LogLikelihoodTarget: "//NUMBER//")")
	CALL WGrTextOrientation(AlignRight)
	CALL WGrTextString(6.0,-0.45,"Reoptimized Other Parameters at CL ")
!Write Column and Row Labels  
	CALL WGrTextFont(FFHelvetica,ISTYLE=0,HEIGHT=0.16/BHGT)
	CALL WGrTextOrientation(AlignLeft)
	CALL WGrTextString(0.3,-0.7,'Parm')
	CALL WGrTextString(1.2,-0.7,'Type')
	DO IPARM=1,4
		CALL WGrTextString(0.3,-0.75-0.18*((IPARM-1)*2+1),PARMNAME(IPARM,MODOPT))
		DO IDIR=1,2
		CALL WGrTextString(1.2,-0.75-0.18*((IPARM-1)*2+IDIR),CLTYPE(IDIR))
		ENDDO
	ENDDO
	CALL WGrTextOrientation(AlignRight)
	DO ICOL=1,6
		CALL WGrTextString(COLLOC(ICOL),-0.7,COLNAME(ICOL))
	ENDDO
	CALL WGrTextString(COLLOC(11),-0.7,COLNAME(7))
!Loop Through Params and CLs
	CALL WGrTextFont(FFHelvetica,ISTYLE=0,HEIGHT=0.15/BHGT)
	DO IPARM=1,4
		IF(IPARM.EQ.1.OR.IPARM.EQ.5) THEN
			ICOL1=2
			ICOL2=3
			ICOL3=4
		ELSEIF(IPARM.EQ.2) THEN
			ICOL1=1
			ICOL2=3
			ICOL3=4
		ELSEIF(IPARM.EQ.3) THEN
			ICOL1=1
			ICOL2=2
			ICOL3=4
		ELSEIF(IPARM.EQ.4) THEN
			ICOL1=1
			ICOL2=2
			ICOL3=3
		ENDIF
        	CALL WGrTextDouble(COLLOC(1),-0.75-0.18*((IPARM-1)*2+1),FUNCLCL(IPARM),'(F10.3)')
        	CALL WGrTextDouble(COLLOC(2),-0.75-0.18*((IPARM-1)*2+1),PARMLCL(IPARM),'(F9.3)')
        	CALL WGrTextDouble(COLLOC(ICOL1+2),-0.75-0.18*((IPARM-1)*2+1),FITPARMVALatLCL(IPARM,1),'(F9.3)')
        	CALL WGrTextDouble(COLLOC(ICOL2+2),-0.75-0.18*((IPARM-1)*2+1),FITPARMVALatLCL(IPARM,2),'(F9.3)')
        	CALL WGrTextDouble(COLLOC(ICOL3+2),-0.75-0.18*((IPARM-1)*2+1),FITPARMVALatLCL(IPARM,3),'(F9.3)')
		DO IERR=0,4
			CALL	WGrTextInteger(COLLOC(7+IERR),-0.75-0.18*((IPARM-1)*2+1),CLFLAGLCL(IPARM,IERR),2)
		ENDDO
        	CALL WGrTextDouble(COLLOC(1),-0.75-0.18*((IPARM-1)*2+2),FUNCUCL(IPARM),'(F10.3)')
        	CALL WGrTextDouble(COLLOC(2),-0.75-0.18*((IPARM-1)*2+2),PARMUCL(IPARM),'(F9.3)')
        	CALL WGrTextDouble(COLLOC(ICOL1+2),-0.75-0.18*((IPARM-1)*2+2),FITPARMVALatUCL(IPARM,1),'(F9.3)')
        	CALL WGrTextDouble(COLLOC(ICOL2+2),-0.75-0.18*((IPARM-1)*2+2),FITPARMVALatUCL(IPARM,2),'(F9.3)')
        	CALL WGrTextDouble(COLLOC(ICOL3+2),-0.75-0.18*((IPARM-1)*2+2),FITPARMVALatUCL(IPARM,3),'(F9.3)')
		DO IERR=0,4
			CALL	WGrTextInteger(COLLOC(7+IERR),-0.75-0.18*((IPARM-1)*2+2),CLFLAGUCL(IPARM,IERR),2)
		ENDDO
	ENDDO
	BTOP=BTOP-BHGT-0.2
	END SUBROUTINE PRINTCLCALCS

	SUBROUTINE PRINTDATA(BTOP)
	USE WINTERACTER
	USE IONTOXMODEL_INTERFACEVARS
	USE IONTOXMODEL_MODELVARS
	USE RESOURCE
	CHARACTER(LEN=9) COLHEAD(3)/"LogFreeCa","LogTotIon","DataFlag"/
	REAL BTOP,BHGT,BWID,COLLOC(12)/0.35,0.85,1.35,1.95,2.45,2.95,3.55,4.05,4.55,5.15,5.65,6.15/
	INTEGER IDAT,ICOL,IROW,ISET,NROW
!Define Graphics Area and Units for Parameter Grid; Outline Area 
	BWID=6.5
	BHGT=5.7
	CALL IGrArea(0.0,(BTOP-BHGT)/9.5,BWID/6.5,BTOP/9.5)
	CALL IGrUnits(0.0,-BHGT,BWID,0.0)
	CALL IGrLineWidth(1,10)
	CALL IGrBorder()
!Define Font Options and Write Section Heading
	CALL WGrTextOptions(GrTextRatio,RatioHeight)
	CALL WGrTextFont(FFHelvetica,ISTYLE=FSBold,HEIGHT=0.18/BHGT)
	CALL WGrTextOrientation(AlignCentre)
	CALL WGrTextString(3.25,-0.20,"Data Summary")
!Write Column Headings 
	CALL WGrTextFont(FFHelvetica,ISTYLE=0,HEIGHT=0.10/BHGT)
	CALL WGrTextOrientation(AlignCentre)
	DO ISET=1,4
	DO ICOL=1,3
		CALL WGrTextString(COLLOC((ISET-1)*3+ICOL),-0.40,COLHEAD(ICOL))
	ENDDO
	ENDDO
!Write Data in Four Sets of 43 Rows
	NROW=43
	DO ISET=1,4
	DO IROW=1,NROW
		IDAT=(ISET-1)*NROW+IROW
		IF(IDAT.GT.NDAT) EXIT
		CALL WGrTextDouble(COLLOC((ISET-1)*3+1),-0.40-0.12*IROW,XDAT(IDAT),'(F7.4)')
		CALL WGrTextDouble(COLLOC((ISET-1)*3+2),-0.40-0.12*IROW,YDAT(IDAT),'(F7.4)')
		CALL WGrTextInteger(COLLOC((ISET-1)*3+3),-0.40-0.12*IROW,1,1)
	ENDDO
	ENDDO
	END SUBROUTINE PRINTDATA



