!*****************************************
!***Module for Model Analysis Variables***
!*****************************************
	MODULE IONTOXMODEL_MODELVARS
	INTEGER IPHASE							!Flag for Initial Optimization (=1) or Error Analysis (=2)
!***
!***Data Variables
!***
	INTEGER KDAT							!Index for data point for inter-routine communication
	INTEGER NDAT							!Number of data points in input/analysis data sets
	REAL*8 XDAT(200)						!Observed X values for analysis data set 
	REAL*8 YDAT(200)						!Observed Y values for analysis data set 
	REAL XLINE(100),YLINE(100)				!X and Y values for fitted model
!***
!***Model Analysis Variables
!***
	INTEGER MODOPT							!Model option
	INTEGER NPARM,NPARMCL					!Number of model parameters for selected model for initial optimization and error analysis
	INTEGER LPARM(5)/3,4,4,4,4/				!Number of parameters for different models
	INTEGER NPOINT							!Number of points in optimization complex
	INTEGER NITER,NITERSAVE1,NITERSAVE2		!Number of iterations in optimization (saved values for output)
	REAL*8 PARMGUESS(6)						!Initial guesses for model parameters
	REAL*8 PARMSOLUT(6)						!Final optimization solution for model parameters
	REAL*8 PARMTEMP(6)						!Model parameters for inter-routine communication
	REAL*8 PARMDELTA(6)						!Delta values for parameter space in which to create initial search complex
	REAL*8 PARMMIN(6),PARMMAX(6)				!Minimum, maximum limits for parameters
	REAL*8 FUNCSOLUT						!Final function value (-ln(Like))
	REAL*8 AIC,AICNULL							!Akaike information criterion
	REAL*8 DATAMEAN,DATASTDV,LIKENULL
	LOGICAL PRINTFLAG						!Flag for optimization routine printing
	INTEGER MODELERROR(8)					!Error flags
	INTEGER NHIST							!Optimization history - number of saves
	INTEGER HISTITER(500),HISTITERSAVE(5)		!Optimization history - iteration number
	REAL*8 HISTFUNC(500,2),HISTFUNCSAVE(5,2)	!Optimization history - best/worst function values
	REAL*8 HISTPARM(500,6,2),HISTPARMSAVE(5,6,2)!Optimization history - low/high parameter values
!***
!***Confidence Limit Estimation Variables
!***
	REAL*8 CLPARMGUESS(4),CLPARMMIN(4),CLPARMMAX(4),CLPARMDELTA(4)		!Updated initial guesses, min/max, initial complex deltas for parameters in CL phase 
	INTEGER FIXPARM											!Identity of parameter for which CL is being calculated (value fixed while other params reoptimized)
	REAL*8 CLLIKETARGET											!Target value for likelihood statistic at confidence limit
	REAL*8 FIXPARMINIT,FIXPARMMIN,FIXPARMMAX,FIXPARMDELTA			!Initial, min/max, and delta value for FIXPARM in bracketing search
	REAL*8 FIXPARMVAL											!Value for FIXPARM while other parameters optimized
	REAL*8 FIXPARMVALOLD										!Saved value for FIXPARM in bracketing search
	REAL*8 LIKEVALUE											!Likelihood value for FIXPARMVAL after optimizing other parameters
	REAL*8 LIKEVALUEOLD											!Save value for LIKEVALUE in bracketing search
	REAL*8 FIXPARMSEARCH(3)										!Values for FIXPARM in binary search
	REAL*8 LIKESEARCH(3)										!Values for LIKEVALUE in binary search
	REAL*8 PARMLCL(4),PARMUCL(4)									!Solution for parameter confidence limits
	REAL*8 FUNCLCL(4),FUNCUCL(4)									!Likelihood statistic at confidence limit solution

	INTEGER FITPARM1,FITPARM2,FITPARM3							!Identities of parameters being reoptimized while searching for confidence limit of FIXPARM
	REAL*8 FITPARMGUESS(6),FITPARMMIN(6),FITPARMMAX(6),FITPARMDELTA(6)	!Guesses, min/max, and initial complex delta values for parameters other than FIXPARM
	REAL*8 FITPARMSOLUT(6)										!Reoptimized values for parameters other than FIXPARM
	REAL*8 FITPARMVALatLCL(4,3),FITPARMVALatUCL(4,3)							!Parameter values for refitted parameters at confidence limit solution for parameter FIXPARM
	INTEGER CLERROR(8)											!Optimization routine error reporting
	INTEGER CLFLAGLCL(4,0:4),CLFLAGUCL(4,0:4)						!Error flags for confidence limit calculations (saved for output from CLERROR)

	INTEGER NHISTCL											!Number of saves in optimization history for confidence limit calcs 
	INTEGER HISTITERCL(500)										!CL Optimization history - iteration number
	REAL*8 HISTFUNCCL(500,2)									!CL Optimization history - best/worst function values
	REAL*8 HISTPARMCL(500,6,2)									!CL Optimization history - low/high parameter values

	END MODULE IONTOXMODEL_MODELVARS
