!******************
!***Main Program***
!******************
	PROGRAM IONTOXMODEL_MAIN
	USE WINTERACTER
	USE RESOURCE
	USE IONTOXMODEL_INTERFACEVARS
	USE IONTOXMODEL_MODELVARS
	IMPLICIT NONE
	TYPE(WIN_MESSAGE) MESSAGE
	LOGICAL QUIT /.FALSE./
	INTEGER ITYPE,IVALUE,IROW,ICOL
    EXTERNAL QASIMULATIONS
    EXTERNAL CONFLIMITS,WEXIT,GRAPHDATA,GRAPHLINE,CLEARANALYSIS,PARMESTIMATE,GETDATA,OUTPUTRESULTS
!***
!***Initialize Winteracter and open root window
!***
	CALL WInitialise()
	CALL WindowOpen( &
	FLAGS =SysMenuOn+MinButton+FixedSizeWin,X=500,Y=100,&
	MENUID=IDR_MENU1, &
	DIALOGID=IDD_MAIN, &
	TITLE ="Ion Toxicity Model Development")
!***
!***Select main dialog for focus and enable reporting of FieldChanged messages
!***Set and load default model and variable info
!***
	CALL WDialogSelect(IDD_MAIN)
	CALL WMessageEnable(FieldChanged,Enabled)
	MODOPT=2
	NPARM=LPARM(MODOPT)
	DO IROW=1,6
		CALL WGridLabelRow(IDF_MAIN_PARAMETERS_GRID,IROW,PARMNAME(IROW,MODOPT)) 
	ENDDO						
	CALL WGridLabelColumn(IDF_MAIN_DATASET_GRID,1,DATASETHEAD1)
	CALL WGridLabelColumn(IDF_MAIN_DATASET_GRID,2,DATASETHEAD2)
!***
!***Main message loop
!***Get messages from Main dialog until QUIT=TRUE
!***Start SELECT structure for message type
!***
	DO WHILE(.NOT.QUIT)
		CALL WMessage(ITYPE,MESSAGE)
		SELECT CASE (ITYPE)
!***
!***CASE = menu item selected
!***Call corresponding routine
!***
		CASE (MenuSelect)
			SELECT CASE (MESSAGE%VALUE1)
        			CASE (ID_OUTPUTRESULTS)
        				CALL OUTPUTRESULTS()
        			CASE (ID_EXIT)
        				CALL WEXIT(QUIT)
        			CASE (ID_GRAPHDATA)
        				CALL GETDATA()
        				CALL GRAPHDATA()
        				IF(ANALYSISDONE) CALL GRAPHLINE()
        			CASE (ID_PARMESTIMATE)
					CALL WDialogClearField(IDF_MAIN_PREDLINE_GRID)
					CALL WDialogClearField(IDF_MAIN_OPTIMIZATION_GRID)
					DO IROW=1,4
					DO ICOL=5,18
    						CALL WGridClearCell(IDF_MAIN_PARAMETERS_GRID,ICOL,IROW)
					ENDDO
					ENDDO
					CALL IGrSelect(3,IDF_MAIN_GRAPH_FRAME)
					CALL IGrAreaClear()
					IPHASE=1
        				CALL PARMESTIMATE()
				CASE (ID_CONFLIMITS)
					DO IROW=1,4
					DO ICOL=7,18
    						CALL WGridClearCell(IDF_MAIN_PARAMETERS_GRID,ICOL,IROW)
					ENDDO
					ENDDO
					IPHASE=2
					CALL CONFLIMITS()
				CASE (ID_QASIMULATION)
					CALL QASIMULATIONS()
			END SELECT
!***
!***CASE = quit request other than from menu
!***Call WEXIT 
!***
		CASE (CloseRequest)
			CALL WEXIT(QUIT)
!***
!***CASE = window was partially hidden and then reshown
!***Redo graphs as needed
!***
		CASE (Expose)
			IF(ANALYSISDONE) CALL GRAPHDATA()
			IF(ANALYSISDONE) CALL GRAPHLINE()
!***
!***CASE = value changed in some field
!***Start testing details of changes in MESSAGE%VALUE
!***
		CASE (FieldChanged)
!***
!***Model Option Changed
!***
			IF(MESSAGE%VALUE1.EQ.IDF_MAIN_MODOPT_MENU) THEN
				CALL WDialogGetMenu(IDF_MAIN_MODOPT_MENU,IVALUE)
				IF(IVALUE.NE.MODOPT) THEN
					MODOPT=IVALUE
					NPARM=LPARM(MODOPT)
					DO IROW=1,6
						CALL WGridLabelRow(IDF_MAIN_PARAMETERS_GRID,IROW,PARMNAME(IROW,MODOPT)) 
					ENDDO						
					CALL CLEARANALYSIS()
				ENDIF
!***
!***End IF structure for field changes
!***End SELECT structure for main dialog message
!***
			ENDIF
		END SELECT
!***
!***End main DO loop if QUIT = .TRUE.
!***Close main window, and end program
!***
	END DO
	CALL WindowClose()
	STOP
	END PROGRAM IONTOXMODEL_MAIN

!****************************************************************
!***Query Intention to Exit Program and Set QUIT Logical State***
!****************************************************************
	SUBROUTINE WEXIT(QUIT)
	USE WINTERACTER
	IMPLICIT NONE
	LOGICAL QUIT
	CALL WMessageBox(YesNo,QuestionIcon,CommonYes,'Do you really want to quit?','Exit Program')
	IF (WInfoDialog(4).EQ.2) THEN 
		QUIT=.FALSE.
	ELSE
		QUIT=.TRUE.
	ENDIF
	RETURN
	END SUBROUTINE WEXIT
