!*******************************
!***Draw Data and Model Plots***
!*******************************
	SUBROUTINE GRAPHDATA()
	USE WINTERACTER
	USE IONTOXMODEL_INTERFACEVARS
	USE IONTOXMODEL_MODELVARS
	USE RESOURCE
	INTEGER NXTICS,NYTICS,NDECX,NDECY,IDAT,ITIC
	REAL XMINTIC,XMAXTIC,XTICSTEP,XTICS(10)
	REAL YMINTIC,YMAXTIC,YTICSTEP,YTICS(10)
	REAL X1,X2,Y1,Y2,XPOS,YPOS

!***
!***Set TIC Limits and Marks
!***
	XMINTIC=-2.0
	XMAXTIC=1.5
	XTICSTEP=0.5
	NXTICS=8
	DO ITIC=1,NXTICS
		XTICS(ITIC)=XMINTIC+(ITIC-1)*XTICSTEP
	ENDDO
	NDECX=1
	YMINTIC=0.0
	YMAXTIC=3.0
	YTICSTEP=0.5
	NYTICS=7
	DO ITIC=1,NYTICS
		YTICS(ITIC)=YMINTIC+(ITIC-1)*YTICSTEP
	ENDDO
	NDECY=1

!***
!***General Graphics Area Setup and Font Selection:
!***    (1) Select and clear graphics area
!***    (2) Set relative coordinates for page within graphics area and set page units to min, max tics
!***    (3) Set clipping region to graphics area, not page
!***    (4) Set character aspect adjustment factors
!***    (5) Set font number and spacing
!***
	CALL IGrSelect(3,IDF_MAIN_GRAPH_FRAME)
	CALL IGrAreaClear()
	X1=0.15
	X2=0.95
	Y1=0.15
	Y2=0.95
	CALL IGrUnits(0.0,0.0,1.0,1.0)
	CALL IPgArea(X1,Y1,X2,Y2)
	CALL IPgUnits(XMINTIC,YMINTIC,XMAXTIC,YMAXTIC)
	CALL IPgClipRectangle('G')
	CALL IGrCharSpacing('P')
	CALL IGrCharFont(1)

!***
!***Draw Axes and Axis Labels:
!***    (1) Set line width and character size
!***    (2) Draw X and Y axes
!***    (3) Set X-axis label position and draw centered label
!***    (4) Set Y-axis label position and draw centered label (90 degree rotation) 
!***
	CALL IGrLineWidth(NINT(RELTHICKAXIS),NINT(RELTHICKAXIS*15))
	CALL IGrCharSize(RELSIZEAXIS/RELASPECT,RELSIZEAXIS)
	CALL IPgAxes(XMINTIC,YMINTIC)
	CALL IPgXLabelPos(0.6)
	CALL IPgXLabel(TRIM(XLABEL),'C')
	CALL IPgYLabelPos(0.5)
	CALL IPgYLabelLeft(TRIM(YLABEL),'C9')

!***
!***Draw TICs and TIC Labels:
!***    (1) Set line width and character size
!***    (2) For X-axis, set number of decimals and scale position, give user TICs, and draw labels
!***    (2) For Y-axis, set number of decimals and scale position, give user TICs, and draw labels
!***
	CALL IGrLineWidth(NINT(RELTHICKAXIS),NINT(RELTHICKAXIS*15))
	CALL IGrCharSize(RELSIZETIC/RELASPECT,RELSIZETIC)
	CALL IPgDecimalPlaces(NDECX)
	CALL IPgXScalePos(0.25)
	CALL IPgXUserScale(XTICS,NXTICS)
	CALL IPgXScale('NI')
	CALL IPgDecimalPlaces(NDECY)
	CALL IPgYScalePos(1.0)
	CALL IPgYTickPos(XMINTIC,XMAXTIC)
	CALL IPgYUserScale(YTICS,NYTICS)
	CALL IPgYScaleLeft('NI')

!***
!***Draw Scatter Plot of Data:
!***
	DO IDAT=1,NDAT
		XPOS=X1+(X2-X1)*(XDAT(IDAT)-XMINTIC)/(XMAXTIC-XMINTIC)
		IF(YDAT(IDAT).GT.YMINTIC) THEN
			YPOS=Y1+(Y2-Y1)*(YDAT(IDAT)-YMINTIC)/(YMAXTIC-YMINTIC)
		ELSE
			YPOS=Y1
		ENDIF
		CALL IGrColour('Red')
		CALL IGrFillPattern(4)
		IF(ELLIPSEFLAG.EQ.0) THEN
			CALL IGrEllipse(XPOS,YPOS,RELSIZESYMB/120,1.00)
		ELSE
			CALL IGrEllipse(XPOS,YPOS,RELSIZESYMB/120,2.19)
		ENDIF
		CALL IGrColour('Black')
	ENDDO
	RETURN
!***
!***Plot Predicted Line
!***    (1) Clip graph at page (axis limits)
!***    (2) Define line width, define nature of new plot, give style elements, and then draw line using XLINE, YLINE
!***
	ENTRY GRAPHLINE()
	CALL IGrSelect(3,IDF_MAIN_GRAPH_FRAME)
	CALL IPgClipRectangle('P')
	CALL IGrLineWidth(NINT(RELTHICKPLOT),NINT(RELTHICKPLOT*15))
	CALL IPgNewPlot(6,1,100,0,0)
	CALL IPgStyle(1,0,0,0,223,223)
	CALL IPgXYPairs(XLINE,YLINE)
	RETURN
	END SUBROUTINE GRAPHDATA

 


