degree_bin_annual <- function(
  df            = NULL, # df with AT LEAST columns ST_fips (with integer FIPS codes, e.g. 1, 2, 10), model, and years representing an annual time series covering 2006-2096, if sector has variants or impactTypes, see additional parameters below
  gcms          = c("CanESM2", "CCSM4", "GFDL-CM3", "GISS-E2-R", "HadGEM2-ES", "MIROC5"), # make sure formatting in df matches these, pass subset of this vector if only certain GCMs are used in this sector
  gcm_info_file = "GCM Degree Arrival Years.xlsx", # saved in data folder in parent directory
  variant       = FALSE, # T/F depending on whether this sector has different variants, if T df must have a column called variant identifying the different variants
  impactType    = FALSE # T/F depending on whether this sector has different impactTypes, if T df must have a column called impactTypes identifying the different impactTypes
){
  states <- df$ST_fips %>% unique
  states <- setNames(states, states)
  
  variants <- df$variant %>% unique
  variants <- setNames(variants, variants)
  
  impacts <- df$impactType %>% unique
  impacts <- setNames(impacts, impacts)
  
  gcm_df <- dataPath %>%
    file.path(gcm_info_file) %>%
    read_xlsx(sheet = "GCM", range = "A1:C32") %>%
    filter(gcm %in% gcms)
  
  state_df <- map_dfr(.x = states, ~gcm_df, .id = "ST_fips")
  if (variant){
    state_df <- map_dfr(.x = variants, ~state_df, .id = "variant")
  }
  if (impactType){
    state_df <- map_dfr(.x = impacts, ~state_df, .id = "impactType")
  }
  state_df <- state_df %>% mutate(value = NA)
  
  for (i in 1:nrow(state_df)){
    row <- state_df[i,]
    df_i <- df %>%
      filter(ST_fips == row$ST_fips,
             model   == row$gcm)
    if(variant){
      df_i <- df_i %>% filter(variant == row$variant)
    }
    if(impactType){
      df_i <- df_i %>% filter(impactType == row$impactType)
    }
    cols_i <- (row$Arrival_yr - 5):(row$Arrival_yr + 5) %>% as.character
    row$value <- rowMeans(df_i[cols_i])
    state_df[i,] <- row
  }
  return(state_df)
}