###biomod2 Anaxyrus quercicus SDM Projections### 

########################
# Title: A.quercicus.R 
# Description: biomod2 script for Anaxyrus quercicus SDMs
#########################

## Load or Install required packages -- 

## install the latest release of biomod2
devtools::install_github('biomodhub/biomod2')

#install necessary packages
install.packages("gbm3")
install.packages("biomod2")
install.packages("ggplot2")
install.packages("gridExtra")
install.packages("raster")
install.packages("rasterVis")
install.packages("terra")
install.packages("ggtext")
install.packages("tidyterra")
install.packages("profvis")
install.packages("FSA")
install.packages("multcomp")
install.packages("lattice")
install.packages("PMCMRplus")
install.packages("ggpubr")
install.packages("grid")
install.packages("ggthemes")
install.packages("scales")
install.packages("gridExtra")
install.packages("cowplot")
install.packages("tibble")
install.packages("tidyr")
install.packages("dplyr")
install.packages("sf")
install.packages("tidyverse")
install.packages("stringr")
install.packages("Hmisc")
install.packages("forcats")
install.packages("r2symbols")
install.packages("caret")
install.packages("spThin")
install.packages("randomForest")
install.packages("usdm")
install.packages("dismo")
install.packages("ENMeval")
install.packages("maxent")
install.packages('terra', repos='https://rspatial.r-universe.dev')
install.packages("devtools")
install.packages("XGBOOST",)
install.packages("mda")
install.packages("mgcv")
install.packages("earth")
install.packages("maxnet")
install.packages("nnet")
install.packages("car")
install.packages("doParallel")
install.packages("ggpubr")
install.packages("testthat")
install.packages("knitr")
install.packages("markdown")
install.packages("tidyterra")
install.packages("gam")



#load required packages
library(biomod2)
library(ggplot2)
library(gridExtra)
library(raster)
library(rasterVis)
library(terra)
library(ggtext)
library(tidyterra)
library(profvis)
library(FSA)
library(multcomp)
library(lattice)
library(PMCMRplus)
library(ggpubr)
library(grid)
library(ggthemes)
library(scales)
library(gridExtra)
library(cowplot)
library(tibble)
library(tidyr)
library(dplyr)
library(sf)
library(tidyverse)
library(scales)
library(stringr)
library(Hmisc)
library(forcats)
library(ggthemes)
library(r2symbols)
library(caret)
library(spThin)
library(randomForest)
library(usdm)
library(dismo)
library(ENMeval)
library(xgboost)
library(devtools)
library(mda)
library(mgcv)
library(earth)
library(maxnet)
library(nnet)
library(car)
library(doParallel)
library(ggpubr)
library(testthat)
library(knitr)
library(markdown)
library(tidyterra)
library(gam)

#required to use the maxent algorithm
path_to_maxent.jar = getwd()
system.file("java", package="dismo")


#Removes packages --> helpful if they need to be uninstalled and updated
detach("package:biomod2", unload = TRUE)
detach("package:ggplot2", unload = TRUE)
detach("package:gridExtra", unload = TRUE)
detach("package:raster", unload = TRUE)
detach("package:rasterVis", unload = TRUE)
detach("package:terra", unload = TRUE)
detach("package:ggtext", unload = TRUE)
detach("package:tidyterra", unload = TRUE)
detach("package:profvis", unload = TRUE)
detach("package:FSA", unload = TRUE)
detach("package:multcomp", unload = TRUE)
detach("package:lattice", unload = TRUE)
detach("package:PMCMRplus", unload = TRUE)
detach("package:ggpubr", unload = TRUE)
detach("package:grid", unload = TRUE)
detach("package:ggthemes", unload = TRUE)
detach("package:scales", unload = TRUE)
detach("package:gridExtra", unload = TRUE)
detach("package:cowplot", unload = TRUE)
detach("package:tibble", unload = TRUE)
detach("package:tidyr", unload = TRUE)
detach("package:dplyr", unload = TRUE)
detach("package:sf", unload = TRUE)
detach("package:tidyverse", unload = TRUE)
detach("package:stringr", unload = TRUE)
detach("package:scales", unload = TRUE)
detach("package:Hmisc", unload = TRUE)
detach("package:forcats", unload = TRUE)
detach("package:r2symbols", unload = TRUE)
detach("package:caret", unload = TRUE)
detach("package:spThin", unload = TRUE)


######## Load species occurrence data --------

## Load Anaxyrus quercicus data -- 

#set working directory for data
setwd("E:/SDM/SDM/Data")
#setwd("L:/lab/CSS/Translators/SpatialAnalysis/SDM/data")

#AnaxQue_occ <- read.csv('../data/AnaxQue_occ.csv')
#summary(AnaxQue_occ)

#load iNaturalist data for Lith.cap
Amphi_occ_iNat <- read.csv('../Data/Anaxyrus_quercicus_occ_iNat_R.csv') #iNat data has to be rounded to 6 decimals to remove dups
Amphi_occ_iNat <- subset(Amphi_occ_iNat, select = -c(id))
summary(Amphi_occ_iNat)

#load gbif data for Lith.cap
Amphi_occ_GBIF <- read.csv('../Data/Anaxyrus_quercicus_occ_gbif_R.csv')
summary(Amphi_occ_GBIF)

#combine iNaturalist data and gbif data
Amphi_occ <- rbind(Amphi_occ_iNat, Amphi_occ_GBIF)
summary(Amphi_occ)

#remove duplicated rows based on lat and long values
Amphi_occ <- Amphi_occ %>% distinct(latitude, longitude, .keep_all = TRUE)


#Thin the occurrence observations --
  #radius (thin.par) based on the species home range and movement


#run thinning code once --> select one of the five csv's with thinned point features
Amphi_occThin <- thin(
    Amphi_occ,
    lat.col = "latitude",
    long.col = "longitude",
    spec.col = "Anaxyrus.quercicus",
    thin.par = 5, #changed to 5 km based on Struecker and Milanovich 2016* and number of initial observations
    reps = 10,
    locs.thinned.list.return = FALSE,
    write.files = TRUE,
    max.files = 5, #number of csv's generated
    out.dir = "A.quercicus_Thinning", #output directory
    out.base = "Amphi_occThin", #file name base
    write.log.file = TRUE,
    log.file = "Anaxyrus.quercicus_spatial_thin_log.txt",
    verbose = TRUE
    )
#summaryThin(Amphi_occThin, show = TRUE)

#*Struecker and Milanovich 2016 - thinned observation data based on 5 km radius for this taxa

#load thinned data
Amphi_occ_thin <- read.csv('../Data/A.quercicus_Thinning/Amphi_occThin_thin1.csv') #thinned at 5km
Amphi_occ <- subset(Amphi_occ_thin, latitude < 42) #remove observations outside the current IUCN range

#Load environmental rasters -- 

#climate data

#set working directory for current climate data
setwd("E:/SDM/ArcGISPro/DataFiles/ClimateLayers/WorldClimRasters/CurrentClimate/Current_wc_30s")

#30 arc second resolution -- Higher resolution
#30 arc sec resolution environmental variables --> renamed so the future climate vars will work
#***names of the current raster layers must match the names of the future climate raster layers
WC_bio1 <- raster("bio01.tif")
WC_bio2 <- raster("bio02.tif")
WC_bio3 <- raster("bio03.tif")
WC_bio7 <- raster("bio07.tif")
WC_bio8 <- raster("bio08.tif")
WC_bio9 <- raster("bio09.tif")
WC_bio15 <- raster("bio15.tif")
WC_bio16 <- raster("bio16.tif")
WC_bio17 <- raster("bio17.tif")
WC_bio18 <- raster("bio18.tif")
WC_bio19 <- raster("bio19.tif")



#Elevation data --

#working directory for elevation layer
setwd("E:/SDM/ArcGISPro/DataFiles/elevation/data")
#setwd("L:/lab/CSS/Translators/SpatialAnalysis/ArcGISPro/DataFiles/elevation/data")

#30 second resolution elevation data --> note: is not elevation for entire CONUS
#SE US elevation layer
SEUS_elev <- raster("CONUS_Elevation.tif")
#st_crs(SEUS_elev) #check coordinate reference system
#SEUS_elev #information about the raster
plot(SEUS_elev) #visualize the raster

#NE US elevation layer
NEUS_elev <- raster("gt30w100n90.tif")
#st_crs(SEUS_elev) #check coordinate reference system
#SEUS_elev #information about the raster
plot(NEUS_elev) #visualize the raster

#Merge NE and SE US elevation layers
US_elev <- merge(SEUS_elev, NEUS_elev)
plot(US_elev)



#Land cover data --


#working directory for land cover data
setwd("E:/SDM/ArcGISPro/DataFiles/LandCover/Historical")
#250m resolution land cover raster
#***names of the current raster layers must match the names of the future climate raster layers
LC_2005 <- raster("CONUS_LandCover.tif") #original file from download -> try reprojecting with new code
LC_2005_proj <- projectRaster(LC_2005, WC_bio19, method='bilinear') #re project with correct res
#projectRaster options:'bilinear' (only for numeric rasters -> changes values) or 'ngb' (nearest neighbor)
st_crs(LC_2005_proj) #check coordinate reference system --> crs is in albers and not WGS84
#plot(LC_2005_proj) #plots the raster --> extent is not right -> cropped below


#load extents --

#north america lat/long extent
#ex <- extent(-170, -50, 15, 90)

#SE US lat/long extent
SE_ex <- extent(-97,-70,25,42) #adjusted for oak toad


#Crop rasters to SE US Extent --
#30 arc sec/10 arc min resolution environ vars --> layers properly named for future climate analysis
#***ensure that the rasters are in the proper resolution
WC_bio1_crop <- crop(WC_bio1, SE_ex)
WC_bio2_crop <- crop(WC_bio2, SE_ex)
WC_bio3_crop <- crop(WC_bio3, SE_ex)
WC_bio7_crop <- crop(WC_bio7, SE_ex)
WC_bio8_crop <- crop(WC_bio8, SE_ex)
WC_bio9_crop <- crop(WC_bio9, SE_ex)
WC_bio15_crop <- crop(WC_bio15, SE_ex)
WC_bio16_crop <- crop(WC_bio16, SE_ex)
WC_bio17_crop <- crop(WC_bio17, SE_ex)
WC_bio18_crop <- crop(WC_bio18, SE_ex)
WC_bio19_crop <- crop(WC_bio19, SE_ex)
US_elev_crop <- crop(US_elev, SE_ex)
LC_2005_crop <- crop(LC_2005_proj, SE_ex)

#Create Raster Stack for Models --
#changed raster layer names --> layers properly labeled for future climate analysis
#Climate, elevation. and, land use layers raster stack
bioclim_SE_US_sub <-
raster::stack(c(WC_bio1_crop, WC_bio2_crop, WC_bio3_crop, WC_bio7_crop,
                                WC_bio8_crop, WC_bio9_crop, WC_bio15_crop, WC_bio16_crop,
                                WC_bio17_crop, WC_bio18_crop, WC_bio19_crop, US_elev_crop,
                                LC_2005_crop))
bioclim_SE_US_sub #check raster layer names --> names must match layers from future climate projections


#create df of explanatory variables from rasterstack -> used for corvif analysis
bioclim_SE_US_sub_df <- as.data.frame(bioclim_SE_US_sub)#, xy = TRUE)
bioclim_SE_US_sub_df


#Variation inflation factor analysis - 
#Remove highly correlated variables (rasters)

vif_result <- vifcor(bioclim_SE_US_sub_df, 0.7)#, keep = c('bio18'))
#identify co-linear variables that should be excluded
print(vif_result)

##Save results below -- 


#removed variables based on the results from the step-wise VIF function
vifStep_result <- vifstep(bioclim_SE_US_sub_df, th=10)
#identify co-linear variables that should be excluded
vifStep_result


##Save results below -- 



#Climate, elevation. and, land use layers rasterstack w/ highly correlated variables removed
bioclim_SE_US_sub <-
raster::stack(c(#WC_bio1_crop,
    WC_bio2_crop,
    WC_bio3_crop,
    #WC_bio7_crop,
    WC_bio8_crop,
    WC_bio9_crop,
    WC_bio15_crop,
    WC_bio16_crop,
    #WC_bio17_crop,
    WC_bio18_crop,
    #WC_bio19_crop,
    US_elev_crop,
    LC_2005_crop))
bioclim_SE_US_sub #check raster layer names --> names must match layers from future climate projections
names(bioclim_SE_US_sub) <- c("bio02", "bio03", "bio08", "bio09", "bio15", "bio16","bio18", "CONUS_Elevation", "CONUS_LandCover")
bioclim_SE_US_sub

#Format the data for model selection -- 

#working directory for output
setwd("E:/SDM/SDM/Output")

#biomod2 data formatting
  Amphi_data <- BIOMOD_FormatingData(
    resp.var = Amphi_occ['Anaxyrus.quercicus'], #presence data and update for new species ---
    resp.xy = Amphi_occ[, c('longitude', 'latitude')], #location data
    expl.var = bioclim_SE_US_sub, #climate variables
    resp.name = "Anaxyrus.quercicus", ##update when looking at different species ---
    PA.nb.rep = 21, #number of sets of pseudo absences selected
    PA.nb.absences = c(rep(788,10), rep(1000,10), rep(10000,1)), #number pseudo absences selected --> PA strategy based on Barbet-Massin et al. 2012
    PA.strategy = 'random' # random/disk approaches are the best
    )
Amphi_data
#plot(Amphi_data)



# Default modeling options. 
bm_DefaultModelingOptions() #Copy, change what you want, and paste it as arg to BIOMOD_ModelingOptions() to specify tuned parameters.

  

#Determine Model Options --
  
#Model lists
allModels <- c( 'FDA', 'GAM', 'GBM', 'GLM',
                'MARS', 'MAXNET', 'RF', 'XGBOOST', 'MAXENT', 
                'ANN', 'CTA', 'SRE')
SelectModels <- c('GBM','XGBOOST', 'GLM')

#load default model options to tune the selected models
Amphi_Options <- bm_ModelingOptions(
  data.type = "binary",
  models = allModels, #SelectModels,
  strategy = "default",
  user.val = NULL,
  user.base = "bigboss",
  bm.format = Amphi_data,
  calib.lines = NULL)
Amphi_Options


## Generate biomod2 model output w/default parameters -- 

setwd("E:/SDM/SDM/Output")

AmphiModelOut <- BIOMOD_Modeling(bm.format = Amphi_data,
                                 modeling.id = 'AllModels',
                                 models = c("GLM",
                                            "GBM",
                                            "RF", #select final algo options based on ROC/TSS plot
                                            "GAM",
                                            "CTA",
                                            "ANN", #ANN models fail every time
                                            "FDA",
                                            "SRE",
                                            "MARS",
                                            "MAXENT", 
                                            "MAXNET",
                                            "XGBOOST"
                                 ),
                                 bm.options = Amphi_Options, #model settings --> select tuned or default settings above
                                 models.pa = list(
                                   "GBM" = c("PA1","PA2","PA3","PA4","PA5","PA6","PA7","PA8","PA9","PA10"),
                                   "XGBOOST" = c("PA1","PA2","PA3","PA4","PA5","PA6","PA7","PA8","PA9","PA10"),
                                   "ANN" = c("PA1","PA2","PA3","PA4","PA5","PA6","PA7","PA8","PA9","PA10"),
                                   "RF" = c("PA1","PA2","PA3","PA4","PA5","PA6","PA7","PA8","PA9","PA10"),
                                   "CTA" = c("PA1","PA2","PA3","PA4","PA5","PA6","PA7","PA8","PA9","PA10"),
                                   "FDA" = c("PA11","PA12","PA13","PA14","PA15","PA16","PA17","PA18","PA19","PA20"),
                                   "SRE" = c("PA11","PA12","PA13","PA14","PA15","PA16","PA17","PA18","PA19","PA20"),
                                   "MARS" = c("PA11","PA12","PA13","PA14","PA15","PA16","PA17","PA18","PA19","PA20"),
                                   "GLM" = c("PA21"), 
                                 "GAM" = c("PA21"),
                                 "MAXNET" = c("PA21"),
                                 "MAXENT" = c("PA21")), #Removed MAXENT because it was lowering the cutoff significantly
                                 CV.strategy = 'env', #environmentally stratified cross validation strategy utilized
                                 CV.k = 2,
                                 CV.balance = "presences",
                                 CV.strat = "both",
                                 var.import = 1,
                                 metric.eval = c('TSS','ROC'))  #'KAPPA'
AmphiModelOut #check for failed models
get_built_models(AmphiModelOut)


#select the highest performing algorithms that do not over fit the models
bm_PlotEvalMean(bm.out = AmphiModelOut, #Plots the mean and SD of the evaluation metrics
                group.by = "algo", 
                metric.eval = c("TSS", "ROC"),
                xlim = c(0.7,1),
                ylim = c(0.7,1))



#Rerun the first steps with tuned parameters for the selected algorithms --


#biomod2 data formatting
  #generate new PA sets based on the selected algorithms

Amphi_data <- BIOMOD_FormatingData(
  resp.var = Amphi_occ['Anaxyrus.quercicus'], #presence data and update for new species ---
  resp.xy = Amphi_occ[, c('longitude', 'latitude')], #location data
  expl.var = bioclim_SE_US_sub, #climate variables
  resp.name = "Anaxyrus.quercicus", ##update when looking at different species ---
  PA.nb.rep = 11, #number of sets of pseudo absences selected
  PA.nb.absences = c(rep(788,10), rep(10000,1)), #rep(1000,10),#number pseudo absences selected --> PA strategy based on Barbet-Massin et al. 2012
  PA.strategy = 'random' # random/disk approaches are the best
)
Amphi_data
#plot(Amphi_data)



#Tuning the selected algorithms --

  
#Tune GBM
tuned.gbm <- bm_Tuning(model = 'GBM',
                       tuning.fun = 'gbm', ## see in ModelsTable
                       do.formula = FALSE,
                       #do.stepAIC = FALSE,
                       bm.options = Amphi_Options@options$GBM.binary.gbm,
                       metric.eval = "TSS",
                       metric.AIC = "AIC",
                       bm.format = Amphi_data)
tuned.gbm

#Tune xgboost
tuned.xgboost <- bm_Tuning(model = 'XGBOOST',
                                    tuning.fun = 'xgbTree', ## see in ModelsTable
                                    do.formula = FALSE,
                                    #do.stepAIC = FALSE,
                                    bm.options = Amphi_Options@options$XGBOOST.binary.xgboost,
                                    metric.eval = "TSS",
                                    metric.AIC = "AIC",
                                    bm.format = Amphi_data)

tuned.xgboost

#GLM cannot be tuned using biomod2 functions


#Define user parameters for each algorithm/run -- 

#Define and update based on tuning output for each run

user.GBM <- list('_PA1_allRun' = list(n.trees = 1000,
                                 interaction.depth = 8,
                                 n.minobsinnode = 10,
                                 shrinkage = 0.01),
                 '_PA2_allRun' = list(n.trees = 2500,
                                 interaction.depth = 5,
                                 n.minobsinnode = 10,
                                 shrinkage = 0.01),
                 '_PA3_allRun' = list(n.trees = 1000,
                                 interaction.depth = 8,
                                 n.minobsinnode = 10,
                                 shrinkage = 0.01),
                 '_PA4_allRun' = list(n.trees = 1000,
                                 interaction.depth = 8,
                                 n.minobsinnode = 10,
                                 shrinkage = 0.01),
                 '_PA5_allRun' = list(n.trees = 1000,
                                 interaction.depth = 8,
                                 n.minobsinnode = 10,
                                 shrinkage = 0.01),
                 '_PA6_allRun' = list(n.trees = 500,
                                 interaction.depth = 5,
                                 n.minobsinnode = 10,
                                 shrinkage = 0.01),
                 '_PA7_allRun' = list(n.trees = 1000,
                                 interaction.depth = 8,
                                 n.minobsinnode = 10,
                                 shrinkage = 0.01),
                 '_PA8_allRun' = list(n.trees = 500,
                                 interaction.depth = 5,
                                 n.minobsinnode = 10,
                                 shrinkage = 0.01),
                 '_PA9_allRun' = list(n.trees = 1000,
                                 interaction.depth = 5,
                                 n.minobsinnode = 10,
                                 shrinkage = 0.01),
                 '_PA10_allRun' = list(n.trees = 1000,
                                  interaction.depth = 8,
                                  n.minobsinnode = 10,
                                  shrinkage = 0.01))#,
# '_allData_allRun' = list(n.trees = 2500,
  #                     interaction.depth = 7,
  ##                   n.minobsinnode = 5,
  #                 shrinkage = 0.001))


user.XGBOOST <- list('_PA1_allRun' = list(nrounds = 50,
                                     max_depth = 1,
                                     eta = 0.3,
                                     gamma = 0,
                                     colsample_bytree = 0.6,
                                     min_child_weight = 1,
                                     subsample = 0.5),
                     '_PA2_allRun' = list(nrounds = 50,
                                     max_depth = 1,
                                     eta = 0.4,
                                     gamma = 0,
                                     colsample_bytree = 0.6,
                                     min_child_weight = 1,
                                     subsample = 0.5),
                     '_PA3_allRun' = list(nrounds = 50,
                                     max_depth = 1,
                                     eta = 0.4,
                                     gamma = 0,
                                     colsample_bytree = 0.8,
                                     min_child_weight = 1,
                                     subsample = 0.5),
                     '_PA4_allRun' = list(nrounds = 50,
                                     max_depth = 1,
                                     eta = 0.4,
                                     gamma = 0,
                                     colsample_bytree = 0.8,
                                     min_child_weight = 1,
                                     subsample = 0.5),
                      '_PA5_allRun' = list(nrounds = 50,
                                           max_depth = 1,
                                           eta = 0.3,
                                           gamma = 0,
                                           colsample_bytree = 0.8,
                                           min_child_weight = 1,
                                           subsample = 0.5),
                      '_PA6_allRun' = list(nrounds = 50,
                                           max_depth = 1,
                                           eta = 0.3,
                                           gamma = 0,
                                           colsample_bytree = 0.6,
                                           min_child_weight = 1,
                                           subsample = 0.5),
                       '_PA7_allRun' = list(nrounds = 50,
                                       max_depth = 1,
                                       eta = 0.4,
                                       gamma = 0,
                                       colsample_bytree = 0.6,
                                       min_child_weight = 1,
                                       subsample = 0.5),
                        '_PA8_allRun' = list(nrounds = 50,
                                       max_depth = 1,
                                       eta = 0.3,
                                       gamma = 0,
                                       colsample_bytree = 0.6,
                                       min_child_weight = 1,
                                       subsample = 0.5),
                         '_PA9_allRun' = list(nrounds = 50,
                                       max_depth = 1,
                                         eta = 0.4,
                                         gamma = 0,
                                         colsample_bytree = 0.8,
                                         min_child_weight = 1,
                                         subsample = 0.5),
                          '_PA10_allRun' = list(nrounds = 50,
                                           max_depth = 1,
                                           eta = 0.3,
                                           gamma = 0,
                                           colsample_bytree = 0.6,
                                           min_child_weight = 1,
                                           subsample = 0.5))

#Default settings for GLM
user.GLM <- list('_PA11_allRun' = list())#family = binomial(link = 'logit'),

#compile user validated model settings
user.val <- list(GBM.binary.gbm.gbm = user.GBM,
                 XGBOOST.binary.xgboost.xgboost = user.XGBOOST,
                 GLM.binary.stats.glm = user.GLM)

#Update model options with user defined model settings
Amphi_Options <- bm_ModelingOptions(data.type = 'binary',
                                    models = c( "GBM", "XGBOOST", "GLM"),
                                    strategy = "user.defined",
                                    user.val = user.val,
                                    #user.base = "bigboss",
                                    bm.format = Amphi_data)
Amphi_Options

#Run if including MAXENT **
#cl <- makeCluster(2)
#registerDoParallel(cl)
#on.exit(stopCluster(cl))


## Generate biomod2 model output w/ tuned parameters -- 

setwd("E:/SDM/SDM/Output")

AmphiModelOut <- BIOMOD_Modeling(bm.format = Amphi_data,
                                             modeling.id = 'AllModels',
                                             models = c("GLM",
                                                        "GBM",
                                                        #"RF", #select final algo options based on ROC/TSS plot
                                                        #"GAM",
                                                        #"CTA",
                                                        #"ANN", #ANN models fail every time
                                                        #"FDA",
                                                        #"SRE",
                                                        #"MARS",
                                                        #"MAXENT", 
                                                        #"MAXNET",
                                                        "XGBOOST"
                                                        ),
                                              bm.options = Amphi_Options, #model settings --> select tuned or default settings above
                                              models.pa = list(
                                                 "GBM" = c("PA1","PA2","PA3","PA4","PA5","PA6","PA7","PA8","PA9","PA10"),
                                                 "XGBOOST" = c("PA1","PA2","PA3","PA4","PA5","PA6","PA7","PA8","PA9","PA10"),
                                                 #"ANN" = c("PA1","PA2","PA3","PA4","PA5","PA6","PA7","PA8","PA9","PA10"),
                                                 #"RF" = c("PA1","PA2","PA3","PA4","PA5","PA6","PA7","PA8","PA9","PA10"),
                                                 #"CTA" = c("PA1","PA2","PA3","PA4","PA5","PA6","PA7","PA8","PA9","PA10"),
                                                 #"FDA" = c("PA11","PA12","PA13","PA14","PA15","PA16","PA17","PA18","PA19","PA20"),
                                                 #"SRE" = c("PA11","PA12","PA13","PA14","PA15","PA16","PA17","PA18","PA19","PA20"),
                                                 #"MARS" = c("PA11","PA12","PA13","PA14","PA15","PA16","PA17","PA18","PA19","PA20"),
                                                 "GLM" = c("PA11")), 
                                                 #"GAM" = c("PA21"),
                                                 #"MAXNET" = c("PA21")),
                                                 #"MAXENT" = c("PA21")), #Removed MAXENT because it was lowering the cutoff significantly
                                               CV.strategy = 'env',
                                               CV.k = 2,
                                               CV.balance = "presences",
                                               CV.strat = "both",
                                               var.import = 1,
                                               metric.eval = c('TSS','ROC'))  #'KAPPA'
AmphiModelOut #check for failed model
get_built_models(AmphiModelOut)

setwd("E:/SDM/SDM/Output")
load("Anaxyrus.quercicus/Anaxyrus.quercicus.AllModels.models.out")
## Be careful, the object within R as the same name as its filename !
## You can rename it if you prefer :
AmphiModelOut <- Anaxyrus.quercicus.AllModels.models.out


cutoff <- get_evaluations(AmphiModelOut) #summarizes evaluation results
write.csv(cutoff, file = "cutoff.csv")


#summarizes variable importance
get_var_import <- get_variables_importance(AmphiModelOut)
attach(get_var_import)
names(get_var_import)
summary_var_import <- tapply(var.imp, list(expl.var, algo), mean)
summary_var_import
write.csv(summary_var_import, file = "summary_var_import.csv")
summary_var_import_algoPA <- tapply(var.imp, list(expl.var, algo, PA), mean)
summary_var_import_algoPA
write.csv(summary_var_import_algoPA, file = "summary_var_import_algoPA.csv")


#List of all of the built models
get_built_models(AmphiModelOut) 


#Model evaluation metrics by algorithm
bm_PlotEvalMean(bm.out = AmphiModelOut, #Plots the mean and SD of the evaluation metrics
                          group.by = "algo", 
                          metric.eval = c("TSS", "ROC"),
                          xlim = c(0.7,1),
                          ylim = c(0.7,1))




#Assess for unwanted evaluation metrics within different subgroups
bm_PlotEvalBoxplot(bm.out = AmphiModelOut, group.by = c('algo', 'algo'))
bm_PlotEvalBoxplot(bm.out = AmphiModelOut, group.by = c('algo', 'PA'))
bm_PlotEvalBoxplot(bm.out = AmphiModelOut, group.by = c('algo', 'run'))
bm_PlotVarImpBoxplot(bm.out = AmphiModelOut, group.by = c('expl.var', 'algo', 'algo'))
bm_PlotVarImpBoxplot(bm.out = AmphiModelOut, group.by = c('expl.var', 'algo', 'run'))
bm_PlotVarImpBoxplot(bm.out = AmphiModelOut, group.by = c('algo', 'expl.var', 'run'))

# Represent response curves - only valuable to look at specific models
bm_PlotResponseCurves(bm.out = AmphiModelOut,
                      models.chosen = get_built_models(AmphiModelOut), #[c(1:3, 12:14)],
                      fixed.var = 'mean')
bm_PlotResponseCurves(bm.out = AmphiModelOut,
                               models.chosen = get_built_models(AmphiModelOut), #[c(1:3, 12:14)],
                               fixed.var = 'median')
bm_PlotResponseCurves(bm.out = AmphiModelOut,
                               models.chosen = get_built_models(AmphiModelOut), #[c(1:3, 12:14)],
                               fixed.var = 'min')


  
AmphiModelEM <- BIOMOD_EnsembleModeling(bm.mod = AmphiModelOut,
                                                 models.chosen = 'all',
                                                 em.by = 'all',
                                                 em.algo = c(#'EMmean', #
                                                  #'EMcv'), #'EMci', #'EMmedian', 'EMca',
                                                 'EMwmean'), #Weighted mean ensemble approach selected
                                                 metric.select = c('TSS'), #Evaluation metric selected
                                                 metric.select.thresh = c(0.7), #evaluation metric threshold
                                                 metric.eval = c('TSS', 'ROC'),
                                                 var.import = 1,
                                                 EMci.alpha = 0.05, #Alpha confidence interval
                                                 EMwmean.decay = 'proportional')
AmphiModelEM
get_built_models(AmphiModelEM)

#Models that passed the evaluation metric threshold and were included in the ensemble model
ensemble_kept <- get_kept_models(AmphiModelEM) 
write.csv(ensemble_kept, file = "ensemble_kept.csv")

cutoff_ensemble <- get_evaluations(AmphiModelEM) #summarizes evaluation results
write.csv(cutoff_ensemble, file = "cutoff_ensemble.csv")


#summarizes variable importance
get_var_import_EM <- get_variables_importance(AmphiModelEM)
attach(get_var_import_EM)
names(get_var_import_EM)
summary_var_import_EM <- tapply(var.imp, list(expl.var, algo), mean)
summary_var_import_EM
write.csv(summary_var_import_EM, file = "summary_var_import_EM.csv")


# Represent evaluation scores & variables importance

bm_PlotEvalMean(bm.out = AmphiModelEM, 
                group.by = "algo", 
                metric.eval = c("TSS", "ROC"),
                xlim = c(0.7,1),
                ylim = c(0.7,1))


# Represent response curves
bm_PlotResponseCurves(bm.out = AmphiModelEM,
                      models.chosen = get_built_models(AmphiModelEM)[c(1)],
                      fixed.var = 'mean')
bm_PlotResponseCurves(bm.out = AmphiModelEM,
                      models.chosen = get_built_models(AmphiModelEM)[c(1)],
                      fixed.var = 'median')
bm_PlotResponseCurves(bm.out = AmphiModelEM,
                      models.chosen = get_built_models(AmphiModelEM)[c(1)],
                      fixed.var = 'min')
bm_PlotResponseCurves(bm.out = AmphiModelEM,
                      models.chosen = get_built_models(AmphiModelEM)[c(1)],
                      fixed.var = 'max')


#Notes 



#load previously run output
load("Anaxyrus.quercicus/Anaxyrus.quercicus.AllModels.ensemble.models.out")
## Be careful, the object within R as the same name as its filename !
## You can rename it if you prefer :
AmphiModelEM <- Anaxyrus.quercicus.AllModels.ensemble.models.out 


# Project single models
  #Include only the kept models from the ensemble model using the models chosen argument
    #increases the speed of the BIOMOD_Projection() function

AmphiModProj <- BIOMOD_Projection(bm.mod = AmphiModelOut,
                                            proj.name = 'Current',
                                            new.env = bioclim_SE_US_sub,
                                            models.chosen = c("Anaxyrus.quercicus_PA1_RUN1_GBM",       "Anaxyrus.quercicus_PA1_RUN2_GBM",      
                                                              "Anaxyrus.quercicus_PA1_RUN8_GBM",       "Anaxyrus.quercicus_PA1_RUN17_GBM",     
                                                              "Anaxyrus.quercicus_PA1_RUN18_GBM",      "Anaxyrus.quercicus_PA2_RUN1_GBM",      
                                                              "Anaxyrus.quercicus_PA2_RUN2_GBM" ,      "Anaxyrus.quercicus_PA2_RUN8_GBM",      
                                                              "Anaxyrus.quercicus_PA2_RUN16_GBM" ,     "Anaxyrus.quercicus_PA2_RUN17_GBM",     
                                                               "Anaxyrus.quercicus_PA2_RUN18_GBM",      "Anaxyrus.quercicus_PA3_RUN1_GBM",      
                                                              "Anaxyrus.quercicus_PA3_RUN2_GBM",       "Anaxyrus.quercicus_PA3_RUN8_GBM",      
                                                              "Anaxyrus.quercicus_PA3_RUN16_GBM",      "Anaxyrus.quercicus_PA3_RUN17_GBM",     
                                                              "Anaxyrus.quercicus_PA3_RUN18_GBM",      "Anaxyrus.quercicus_PA4_RUN1_GBM",      
                                                              "Anaxyrus.quercicus_PA4_RUN2_GBM" ,      "Anaxyrus.quercicus_PA4_RUN8_GBM",      
                                                              "Anaxyrus.quercicus_PA4_RUN16_GBM" ,     "Anaxyrus.quercicus_PA4_RUN17_GBM",     
                                                               "Anaxyrus.quercicus_PA4_RUN18_GBM",      "Anaxyrus.quercicus_PA5_RUN1_GBM",      
                                                              "Anaxyrus.quercicus_PA5_RUN2_GBM" ,      "Anaxyrus.quercicus_PA5_RUN8_GBM",      
                                                              "Anaxyrus.quercicus_PA5_RUN16_GBM",      "Anaxyrus.quercicus_PA5_RUN17_GBM",     
                                                              "Anaxyrus.quercicus_PA5_RUN18_GBM",      "Anaxyrus.quercicus_PA6_RUN1_GBM",      
                                                              "Anaxyrus.quercicus_PA6_RUN2_GBM" ,      "Anaxyrus.quercicus_PA6_RUN8_GBM",      
                                                              "Anaxyrus.quercicus_PA6_RUN16_GBM" ,     "Anaxyrus.quercicus_PA6_RUN17_GBM",     
                                                              "Anaxyrus.quercicus_PA6_RUN18_GBM",      "Anaxyrus.quercicus_PA7_RUN1_GBM",      
                                                              "Anaxyrus.quercicus_PA7_RUN2_GBM" ,      "Anaxyrus.quercicus_PA7_RUN8_GBM",      
                                                              "Anaxyrus.quercicus_PA7_RUN16_GBM",      "Anaxyrus.quercicus_PA7_RUN17_GBM",     
                                                              "Anaxyrus.quercicus_PA7_RUN18_GBM",      "Anaxyrus.quercicus_PA8_RUN1_GBM",      
                                                              "Anaxyrus.quercicus_PA8_RUN2_GBM" ,      "Anaxyrus.quercicus_PA8_RUN8_GBM",      
                                                              "Anaxyrus.quercicus_PA8_RUN16_GBM",      "Anaxyrus.quercicus_PA8_RUN17_GBM",     
                                                              "Anaxyrus.quercicus_PA8_RUN18_GBM",      "Anaxyrus.quercicus_PA9_RUN1_GBM",      
                                                              "Anaxyrus.quercicus_PA9_RUN2_GBM" ,      "Anaxyrus.quercicus_PA9_RUN8_GBM" ,     
                                                              "Anaxyrus.quercicus_PA9_RUN16_GBM",      "Anaxyrus.quercicus_PA9_RUN17_GBM",     
                                                              "Anaxyrus.quercicus_PA9_RUN18_GBM",      "Anaxyrus.quercicus_PA10_RUN1_GBM",     
                                                              "Anaxyrus.quercicus_PA10_RUN2_GBM",      "Anaxyrus.quercicus_PA10_RUN8_GBM",     
                                                              "Anaxyrus.quercicus_PA10_RUN16_GBM",     "Anaxyrus.quercicus_PA10_RUN17_GBM",    
                                                              "Anaxyrus.quercicus_PA10_RUN18_GBM" ,    "Anaxyrus.quercicus_PA1_RUN2_XGBOOST",  
                                                              "Anaxyrus.quercicus_PA1_RUN17_XGBOOST",  "Anaxyrus.quercicus_PA1_RUN18_XGBOOST", 
                                                              "Anaxyrus.quercicus_PA2_RUN1_XGBOOST",   "Anaxyrus.quercicus_PA2_RUN2_XGBOOST",  
                                                              "Anaxyrus.quercicus_PA2_RUN8_XGBOOST",   "Anaxyrus.quercicus_PA2_RUN17_XGBOOST", 
                                                              "Anaxyrus.quercicus_PA3_RUN1_XGBOOST",   "Anaxyrus.quercicus_PA3_RUN2_XGBOOST",  
                                                              "Anaxyrus.quercicus_PA3_RUN5_XGBOOST",   "Anaxyrus.quercicus_PA3_RUN17_XGBOOST", 
                                                              "Anaxyrus.quercicus_PA3_RUN18_XGBOOST",  "Anaxyrus.quercicus_PA4_RUN1_XGBOOST",
                                                              "Anaxyrus.quercicus_PA4_RUN2_XGBOOST",   "Anaxyrus.quercicus_PA4_RUN16_XGBOOST", 
                                                              "Anaxyrus.quercicus_PA4_RUN17_XGBOOST",  "Anaxyrus.quercicus_PA4_RUN18_XGBOOST" ,
                                                              "Anaxyrus.quercicus_PA5_RUN2_XGBOOST",   "Anaxyrus.quercicus_PA5_RUN16_XGBOOST", 
                                                              "Anaxyrus.quercicus_PA5_RUN18_XGBOOST",  "Anaxyrus.quercicus_PA6_RUN1_XGBOOST",  
                                                              "Anaxyrus.quercicus_PA6_RUN2_XGBOOST",   "Anaxyrus.quercicus_PA6_RUN16_XGBOOST", 
                                                              "Anaxyrus.quercicus_PA6_RUN18_XGBOOST",  "Anaxyrus.quercicus_PA7_RUN1_XGBOOST",  
                                                              "Anaxyrus.quercicus_PA7_RUN8_XGBOOST",   "Anaxyrus.quercicus_PA7_RUN16_XGBOOST", 
                                                              "Anaxyrus.quercicus_PA7_RUN17_XGBOOST",  "Anaxyrus.quercicus_PA7_RUN18_XGBOOST", 
                                                              "Anaxyrus.quercicus_PA8_RUN1_XGBOOST",   "Anaxyrus.quercicus_PA8_RUN2_XGBOOST",  
                                                              "Anaxyrus.quercicus_PA8_RUN8_XGBOOST",   "Anaxyrus.quercicus_PA8_RUN16_XGBOOST", 
                                                              "Anaxyrus.quercicus_PA8_RUN17_XGBOOST",  "Anaxyrus.quercicus_PA8_RUN18_XGBOOST", 
                                                              "Anaxyrus.quercicus_PA9_RUN1_XGBOOST",   "Anaxyrus.quercicus_PA9_RUN2_XGBOOST",  
                                                              "Anaxyrus.quercicus_PA9_RUN8_XGBOOST",   "Anaxyrus.quercicus_PA9_RUN18_XGBOOST", 
                                                              "Anaxyrus.quercicus_PA10_RUN2_XGBOOST",  "Anaxyrus.quercicus_PA10_RUN16_XGBOOST",
                                                              "Anaxyrus.quercicus_PA10_RUN17_XGBOOST", "Anaxyrus.quercicus_PA10_RUN18_XGBOOST",
                                                              "Anaxyrus.quercicus_PA11_RUN1_GLM",      "Anaxyrus.quercicus_PA11_RUN8_GLM",     
                                                              "Anaxyrus.quercicus_PA11_RUN17_GLM",     "Anaxyrus.quercicus_PA11_RUN18_GLM"),#'all',
                                            metric.binary = 'all',
                                            metric.filter = 'all',
                                            output.format = ".img", #default is .tif --> need .img for BIOMOD_RangeSize
                                            build.clamping.mask = TRUE)
AmphiModProj
#plot(AmphiModProj)

#load previously run output
load("Anaxyrus.quercicus/proj_Current/Anaxyrus.quercicus.Current.projection.out")
## Be careful, the object within R as the same name as its filename !
## You can rename it if you prefer :
AmphiModProj <- Anaxyrus.quercicus.Current.projection.out
#plot(AmphiModProj)

#terraOptions(todisk = TRUE)

AmphiMod_ensemble_proj_current <- BIOMOD_EnsembleForecasting(bm.em = AmphiModelEM,
                                                                     bm.proj = AmphiModProj,
                                                                     models.chosen = 'all', #use the get_built_models for possible models
                                                                     metric.binary = 'all',
                                                                     na.rm = FALSE,
                                                                     output.format = ".img", #default is .tif --> need .img for BIOMOD_RangeSize
                                                                     metric.filter = 'all',
                                                                     keep.in.memory = FALSE)
AmphiMod_ensemble_proj_current
plot(AmphiMod_ensemble_proj_current)

#load previosuly run output
load("Anaxyrus.quercicus/proj_Current/Anaxyrus.quercicus.Current.ensemble.projection.out")
## Be careful, the object within R as the same name as its filename !
## You can rename it if you prefer :
AmphiMod_ensemble_proj_current <- Anaxyrus.quercicus.Current.ensemble.projection.out
plot(AmphiMod_ensemble_proj_current)



###########################################################################################

# Run future projections #

#load future climate and land use rasters --

setwd("E:/SDM/ArcGISPro/DataFiles/ClimateLayers/WorldClimRasters/FutureClimate")


#30 arc sec resolution environmental variables MIROC6_2081-2100
WC_MIROC6_ssp585 <- stack("wc2.1_30s_bioc_MIROC6_ssp585_2081-2100.tif")
WC_MIROC6_ssp370 <- stack("wc2.1_30s_bioc_MIROC6_ssp370_2081-2100.tif")
WC_MIROC6_ssp245 <- stack("wc2.1_30s_bioc_MIROC6_ssp245_2081-2100.tif")


#Crop the climate layers to the SE extent and create rasterstack for each ssp --
#ssp585
WC_MIROC6_ssp585_crop_bio1 <- crop(WC_MIROC6_ssp585[[1]], SE_ex)
WC_MIROC6_ssp585_crop_bio2 <- crop(WC_MIROC6_ssp585[[2]], SE_ex)
WC_MIROC6_ssp585_crop_bio3 <- crop(WC_MIROC6_ssp585[[3]], SE_ex)
WC_MIROC6_ssp585_crop_bio7 <- crop(WC_MIROC6_ssp585[[7]], SE_ex)
WC_MIROC6_ssp585_crop_bio8 <- crop(WC_MIROC6_ssp585[[8]], SE_ex)
WC_MIROC6_ssp585_crop_bio9 <- crop(WC_MIROC6_ssp585[[9]], SE_ex)
WC_MIROC6_ssp585_crop_bio15 <- crop(WC_MIROC6_ssp585[[15]], SE_ex)
WC_MIROC6_ssp585_crop_bio16 <- crop(WC_MIROC6_ssp585[[16]], SE_ex)
WC_MIROC6_ssp585_crop_bio17 <- crop(WC_MIROC6_ssp585[[17]], SE_ex)
WC_MIROC6_ssp585_crop_bio18 <- crop(WC_MIROC6_ssp585[[18]], SE_ex)
WC_MIROC6_ssp585_crop_bio19 <- crop(WC_MIROC6_ssp585[[19]], SE_ex)

#A1B --> SSP585
#working directory for A1B land cover data
setwd("E:/SDM/ArcGISPro/DataFiles/LandCover/A1B")

# Load 250m resolution land cover raster
#***names of the current raster layers must match the names of the future land cover raster layers
#*
LC_A1B_2100 <- raster("CONUS_LandCover.tif") #original file from download 
LC_A1B_2100_proj <- projectRaster(LC_A1B_2100, WC_bio19, method='bilinear') #re project with correct res
LC_A1B_2100_crop <- crop(LC_A1B_2100_proj, SE_ex)

#create a raster stack with selected environ vars of interest
bioclim2100_SE_US_sub585 <-
  raster::stack(c(#WC_MIROC6_ssp585_crop_bio1,
    WC_MIROC6_ssp585_crop_bio2, WC_MIROC6_ssp585_crop_bio3, 
    #WC_MIROC6_ssp585_crop_bio7,
    WC_MIROC6_ssp585_crop_bio8, WC_MIROC6_ssp585_crop_bio9, WC_MIROC6_ssp585_crop_bio15,
    WC_MIROC6_ssp585_crop_bio16, #WC_MIROC6_ssp585_crop_bio17, 
    WC_MIROC6_ssp585_crop_bio18, #WC_MIROC6_ssp585_crop_bio19, 
    US_elev_crop, LC_A1B_2100_crop))
names(bioclim2100_SE_US_sub585) <- c("bio02", "bio03", "bio08", "bio09", "bio15", "bio16","bio18", "CONUS_Elevation", "CONUS_LandCover")
bioclim2100_SE_US_sub585 #check raster layer names --> names must match layers from original (current) projections


#ssp370
WC_MIROC6_ssp370_crop_bio1 <- crop(WC_MIROC6_ssp370[[1]], SE_ex)
WC_MIROC6_ssp370_crop_bio2 <- crop(WC_MIROC6_ssp370[[2]], SE_ex)
WC_MIROC6_ssp370_crop_bio3 <- crop(WC_MIROC6_ssp370[[3]], SE_ex)
WC_MIROC6_ssp370_crop_bio7 <- crop(WC_MIROC6_ssp370[[7]], SE_ex)
WC_MIROC6_ssp370_crop_bio8 <- crop(WC_MIROC6_ssp370[[8]], SE_ex)
WC_MIROC6_ssp370_crop_bio9 <- crop(WC_MIROC6_ssp370[[9]], SE_ex)
WC_MIROC6_ssp370_crop_bio15 <- crop(WC_MIROC6_ssp370[[15]], SE_ex)
WC_MIROC6_ssp370_crop_bio16 <- crop(WC_MIROC6_ssp370[[16]], SE_ex)
WC_MIROC6_ssp370_crop_bio17 <- crop(WC_MIROC6_ssp370[[17]], SE_ex)
WC_MIROC6_ssp370_crop_bio18 <- crop(WC_MIROC6_ssp370[[18]], SE_ex)
WC_MIROC6_ssp370_crop_bio19 <- crop(WC_MIROC6_ssp370[[19]], SE_ex)

#A2 --> SSP370
#working directory for A2 land cover data
setwd("E:/SDM/ArcGISPro/DataFiles/LandCover/A2")

#Load 250m resolution land cover raster
LC_A2_2100 <- raster("CONUS_LandCover.tif") #original file from download 
LC_A2_2100_proj <- projectRaster(LC_A2_2100, WC_bio19, method='bilinear') #re project with correct res
LC_A2_2100_crop <- crop(LC_A2_2100_proj, SE_ex)

#create a raster stack with selected environ vars of interest
  bioclim2100_SE_US_sub370 <-
  raster::stack(c(#WC_MIROC6_ssp370_crop_bio1,
    WC_MIROC6_ssp370_crop_bio2, WC_MIROC6_ssp370_crop_bio3, 
    #WC_MIROC6_ssp370_crop_bio7,
    WC_MIROC6_ssp370_crop_bio8, WC_MIROC6_ssp370_crop_bio9, WC_MIROC6_ssp370_crop_bio15,
    WC_MIROC6_ssp370_crop_bio16, #WC_MIROC6_ssp370_crop_bio17, 
    WC_MIROC6_ssp370_crop_bio18, #WC_MIROC6_ssp370_crop_bio19, 
    US_elev_crop, LC_A2_2100_crop))
names(bioclim2100_SE_US_sub370) <- c("bio02", "bio03", "bio08", "bio09", "bio15", "bio16","bio18", "CONUS_Elevation", "CONUS_LandCover")
bioclim2100_SE_US_sub370 #check raster layer names --> names must match layers from original (current) projections

#ssp 245
WC_MIROC6_ssp245_crop_bio1 <- crop(WC_MIROC6_ssp245[[1]], SE_ex)
WC_MIROC6_ssp245_crop_bio2 <- crop(WC_MIROC6_ssp245[[2]], SE_ex)
WC_MIROC6_ssp245_crop_bio3 <- crop(WC_MIROC6_ssp245[[3]], SE_ex)
WC_MIROC6_ssp245_crop_bio7 <- crop(WC_MIROC6_ssp245[[7]], SE_ex)
WC_MIROC6_ssp245_crop_bio8 <- crop(WC_MIROC6_ssp245[[8]], SE_ex)
WC_MIROC6_ssp245_crop_bio9 <- crop(WC_MIROC6_ssp245[[9]], SE_ex)
WC_MIROC6_ssp245_crop_bio15 <- crop(WC_MIROC6_ssp245[[15]], SE_ex)
WC_MIROC6_ssp245_crop_bio16 <- crop(WC_MIROC6_ssp245[[16]], SE_ex)
WC_MIROC6_ssp245_crop_bio17 <- crop(WC_MIROC6_ssp245[[17]], SE_ex)
WC_MIROC6_ssp245_crop_bio18 <- crop(WC_MIROC6_ssp245[[18]], SE_ex)
WC_MIROC6_ssp245_crop_bio19 <- crop(WC_MIROC6_ssp245[[19]], SE_ex)

#B2 --> SSP245
#working directory for B2 land cover data
setwd("E:/SDM/ArcGISPro/DataFiles/LandCover/B2")

#Load 250m resolution land cover raster
LC_B2_2100 <- raster("CONUS_LandCover.tif") #original file from download -> try reprojecting with new code
LC_B2_2100_proj <- projectRaster(LC_B2_2100, WC_bio19, method='bilinear') #re project with correct res
LC_B2_2100_crop <- crop(LC_B2_2100_proj, SE_ex)

#create a raster stack with environ vars of interest
bioclim2100_SE_US_sub245 <-
  raster::stack(c(#WC_MIROC6_ssp245_crop_bio1,
  WC_MIROC6_ssp245_crop_bio2, WC_MIROC6_ssp245_crop_bio3, 
  #WC_MIROC6_ssp245_crop_bio7,
  WC_MIROC6_ssp245_crop_bio8, WC_MIROC6_ssp245_crop_bio9, WC_MIROC6_ssp245_crop_bio15,
  WC_MIROC6_ssp245_crop_bio16, #WC_MIROC6_ssp245_crop_bio17, 
  WC_MIROC6_ssp245_crop_bio18, #WC_MIROC6_ssp245_crop_bio19, 
  US_elev_crop, LC_B2_2100_crop))
names(bioclim2100_SE_US_sub245) <- c("bio02", "bio03", "bio08", "bio09", "bio15", "bio16","bio18", "CONUS_Elevation", "CONUS_LandCover")
bioclim2100_SE_US_sub245 #check raster layer names --> names must match layers from original projections

#optionally check the plot
#plot(WC_MIROC6_ssp585_crop_bio19) #check plot
#plot(WC_MIROC6_ssp370_crop_bio19) #check plot
#plot(WC_MIROC6_ssp245_crop_bio19) #check plot

  
#Create future projections --
  
#working directory for output
setwd("E:/SDM/SDM/output")


## ssp585 ##
# Project single models ssp585 --> 2080-2100
  #Include only the kept models from the ensemble model using the models chosen argument
    #increases the speed of the BIOMOD_Projection() function
AmphiMod2100Proj_ssp585 <- BIOMOD_Projection(bm.mod = AmphiModelOut,
                                             proj.name = '2100_ssp585',
                                             new.env = bioclim2100_SE_US_sub585,
                                             models.chosen = c("Anaxyrus.quercicus_PA1_RUN1_GBM",       "Anaxyrus.quercicus_PA1_RUN2_GBM",      
                                                               "Anaxyrus.quercicus_PA1_RUN8_GBM",       "Anaxyrus.quercicus_PA1_RUN17_GBM",     
                                                               "Anaxyrus.quercicus_PA1_RUN18_GBM",      "Anaxyrus.quercicus_PA2_RUN1_GBM",      
                                                               "Anaxyrus.quercicus_PA2_RUN2_GBM" ,      "Anaxyrus.quercicus_PA2_RUN8_GBM",      
                                                               "Anaxyrus.quercicus_PA2_RUN16_GBM" ,     "Anaxyrus.quercicus_PA2_RUN17_GBM",     
                                                               "Anaxyrus.quercicus_PA2_RUN18_GBM",      "Anaxyrus.quercicus_PA3_RUN1_GBM",      
                                                               "Anaxyrus.quercicus_PA3_RUN2_GBM",       "Anaxyrus.quercicus_PA3_RUN8_GBM",      
                                                               "Anaxyrus.quercicus_PA3_RUN16_GBM",      "Anaxyrus.quercicus_PA3_RUN17_GBM",     
                                                               "Anaxyrus.quercicus_PA3_RUN18_GBM",      "Anaxyrus.quercicus_PA4_RUN1_GBM",      
                                                               "Anaxyrus.quercicus_PA4_RUN2_GBM" ,      "Anaxyrus.quercicus_PA4_RUN8_GBM",      
                                                               "Anaxyrus.quercicus_PA4_RUN16_GBM" ,     "Anaxyrus.quercicus_PA4_RUN17_GBM",     
                                                               "Anaxyrus.quercicus_PA4_RUN18_GBM",      "Anaxyrus.quercicus_PA5_RUN1_GBM",      
                                                               "Anaxyrus.quercicus_PA5_RUN2_GBM" ,      "Anaxyrus.quercicus_PA5_RUN8_GBM",      
                                                               "Anaxyrus.quercicus_PA5_RUN16_GBM",      "Anaxyrus.quercicus_PA5_RUN17_GBM",     
                                                               "Anaxyrus.quercicus_PA5_RUN18_GBM",      "Anaxyrus.quercicus_PA6_RUN1_GBM",      
                                                               "Anaxyrus.quercicus_PA6_RUN2_GBM" ,      "Anaxyrus.quercicus_PA6_RUN8_GBM",      
                                                               "Anaxyrus.quercicus_PA6_RUN16_GBM" ,     "Anaxyrus.quercicus_PA6_RUN17_GBM",     
                                                               "Anaxyrus.quercicus_PA6_RUN18_GBM",      "Anaxyrus.quercicus_PA7_RUN1_GBM",      
                                                               "Anaxyrus.quercicus_PA7_RUN2_GBM" ,      "Anaxyrus.quercicus_PA7_RUN8_GBM",      
                                                               "Anaxyrus.quercicus_PA7_RUN16_GBM",      "Anaxyrus.quercicus_PA7_RUN17_GBM",     
                                                               "Anaxyrus.quercicus_PA7_RUN18_GBM",      "Anaxyrus.quercicus_PA8_RUN1_GBM",      
                                                               "Anaxyrus.quercicus_PA8_RUN2_GBM" ,      "Anaxyrus.quercicus_PA8_RUN8_GBM",      
                                                               "Anaxyrus.quercicus_PA8_RUN16_GBM",      "Anaxyrus.quercicus_PA8_RUN17_GBM",     
                                                               "Anaxyrus.quercicus_PA8_RUN18_GBM",      "Anaxyrus.quercicus_PA9_RUN1_GBM",      
                                                               "Anaxyrus.quercicus_PA9_RUN2_GBM" ,      "Anaxyrus.quercicus_PA9_RUN8_GBM" ,     
                                                               "Anaxyrus.quercicus_PA9_RUN16_GBM",      "Anaxyrus.quercicus_PA9_RUN17_GBM",     
                                                               "Anaxyrus.quercicus_PA9_RUN18_GBM",      "Anaxyrus.quercicus_PA10_RUN1_GBM",     
                                                               "Anaxyrus.quercicus_PA10_RUN2_GBM",      "Anaxyrus.quercicus_PA10_RUN8_GBM",     
                                                               "Anaxyrus.quercicus_PA10_RUN16_GBM",     "Anaxyrus.quercicus_PA10_RUN17_GBM",    
                                                               "Anaxyrus.quercicus_PA10_RUN18_GBM" ,    "Anaxyrus.quercicus_PA1_RUN2_XGBOOST",  
                                                               "Anaxyrus.quercicus_PA1_RUN17_XGBOOST",  "Anaxyrus.quercicus_PA1_RUN18_XGBOOST", 
                                                               "Anaxyrus.quercicus_PA2_RUN1_XGBOOST",   "Anaxyrus.quercicus_PA2_RUN2_XGBOOST",  
                                                               "Anaxyrus.quercicus_PA2_RUN8_XGBOOST",   "Anaxyrus.quercicus_PA2_RUN17_XGBOOST", 
                                                               "Anaxyrus.quercicus_PA3_RUN1_XGBOOST",   "Anaxyrus.quercicus_PA3_RUN2_XGBOOST",  
                                                               "Anaxyrus.quercicus_PA3_RUN5_XGBOOST",   "Anaxyrus.quercicus_PA3_RUN17_XGBOOST", 
                                                               "Anaxyrus.quercicus_PA3_RUN18_XGBOOST",  "Anaxyrus.quercicus_PA4_RUN1_XGBOOST",
                                                               "Anaxyrus.quercicus_PA4_RUN2_XGBOOST",   "Anaxyrus.quercicus_PA4_RUN16_XGBOOST", 
                                                               "Anaxyrus.quercicus_PA4_RUN17_XGBOOST",  "Anaxyrus.quercicus_PA4_RUN18_XGBOOST" ,
                                                               "Anaxyrus.quercicus_PA5_RUN2_XGBOOST",   "Anaxyrus.quercicus_PA5_RUN16_XGBOOST", 
                                                               "Anaxyrus.quercicus_PA5_RUN18_XGBOOST",  "Anaxyrus.quercicus_PA6_RUN1_XGBOOST",  
                                                               "Anaxyrus.quercicus_PA6_RUN2_XGBOOST",   "Anaxyrus.quercicus_PA6_RUN16_XGBOOST", 
                                                               "Anaxyrus.quercicus_PA6_RUN18_XGBOOST",  "Anaxyrus.quercicus_PA7_RUN1_XGBOOST",  
                                                               "Anaxyrus.quercicus_PA7_RUN8_XGBOOST",   "Anaxyrus.quercicus_PA7_RUN16_XGBOOST", 
                                                               "Anaxyrus.quercicus_PA7_RUN17_XGBOOST",  "Anaxyrus.quercicus_PA7_RUN18_XGBOOST", 
                                                               "Anaxyrus.quercicus_PA8_RUN1_XGBOOST",   "Anaxyrus.quercicus_PA8_RUN2_XGBOOST",  
                                                               "Anaxyrus.quercicus_PA8_RUN8_XGBOOST",   "Anaxyrus.quercicus_PA8_RUN16_XGBOOST", 
                                                               "Anaxyrus.quercicus_PA8_RUN17_XGBOOST",  "Anaxyrus.quercicus_PA8_RUN18_XGBOOST", 
                                                               "Anaxyrus.quercicus_PA9_RUN1_XGBOOST",   "Anaxyrus.quercicus_PA9_RUN2_XGBOOST",  
                                                               "Anaxyrus.quercicus_PA9_RUN8_XGBOOST",   "Anaxyrus.quercicus_PA9_RUN18_XGBOOST", 
                                                               "Anaxyrus.quercicus_PA10_RUN2_XGBOOST",  "Anaxyrus.quercicus_PA10_RUN16_XGBOOST",
                                                               "Anaxyrus.quercicus_PA10_RUN17_XGBOOST", "Anaxyrus.quercicus_PA10_RUN18_XGBOOST",
                                                               "Anaxyrus.quercicus_PA11_RUN1_GLM",      "Anaxyrus.quercicus_PA11_RUN8_GLM",     
                                                               "Anaxyrus.quercicus_PA11_RUN17_GLM",     "Anaxyrus.quercicus_PA11_RUN18_GLM"),#'all',
                                             metric.binary = 'all',
                                             metric.filter = 'all',
                                             output.format = ".img", #default is .tif --> need .img for BIOMOD_RangeSize
                                             build.clamping.mask = TRUE)
AmphiMod2100Proj_ssp585
#plot(AmphiMod2100Proj_ssp585)

#load previously run output
#load("Anaxyrus.quercicus/proj_2100_ssp585/Anaxyrus.quercicus.2100_ssp585.projection.out")
## Be careful, the object within R as the same name as its filename !
## You can rename it if you prefer :
#AmphiMod2100Proj_ssp585 <- Anaxyrus.quercicus.2100_ssp585.projection.out


#Ensemble model forecasting ssp585 --> 2080-2100
AmphiMod_ensemble_2100Proj_ssp585 <- BIOMOD_EnsembleForecasting(bm.em = AmphiModelEM,
                                                                bm.proj = AmphiMod2100Proj_ssp585,
                                                                models.chosen = 'all', #use the get_built_models for possible models
                                                                metric.binary = 'all',
                                                                output.format = ".img", #default is .tif --> need .img for BIOMOD_RangeSize
                                                                metric.filter = 'all')
AmphiMod_ensemble_2100Proj_ssp585
plot(AmphiMod_ensemble_2100Proj_ssp585)

#load previously run output
load("Anaxyrus.quercicus/proj_2100_ssp585/Anaxyrus.quercicus.2100_ssp585.ensemble.projection.out")
## Be careful, the object within R as the same name as its filename !
## You can rename it if you prefer :
AmphiMod_ensemble_2100Proj_ssp585 <- Anaxyrus.quercicus.2100_ssp585.ensemble.projection.out
plot(AmphiMod_ensemble_2100Proj_ssp585)


## ssp370 ##

# Project single models ssp370 --> 2080-2100
  #Include only the kept models from the ensemble model using the models chosen argument
    #increases the speed of the BIOMOD_Projection() function

AmphiMod2100Proj_ssp370 <- BIOMOD_Projection(bm.mod = AmphiModelOut,
                                             proj.name = '2100_ssp370',
                                             new.env = bioclim2100_SE_US_sub370,
                                             models.chosen = c("Anaxyrus.quercicus_PA1_RUN1_GBM",       "Anaxyrus.quercicus_PA1_RUN2_GBM",      
                                                               "Anaxyrus.quercicus_PA1_RUN8_GBM",       "Anaxyrus.quercicus_PA1_RUN17_GBM",     
                                                               "Anaxyrus.quercicus_PA1_RUN18_GBM",      "Anaxyrus.quercicus_PA2_RUN1_GBM",      
                                                               "Anaxyrus.quercicus_PA2_RUN2_GBM" ,      "Anaxyrus.quercicus_PA2_RUN8_GBM",      
                                                               "Anaxyrus.quercicus_PA2_RUN16_GBM" ,     "Anaxyrus.quercicus_PA2_RUN17_GBM",     
                                                               "Anaxyrus.quercicus_PA2_RUN18_GBM",      "Anaxyrus.quercicus_PA3_RUN1_GBM",      
                                                               "Anaxyrus.quercicus_PA3_RUN2_GBM",       "Anaxyrus.quercicus_PA3_RUN8_GBM",      
                                                               "Anaxyrus.quercicus_PA3_RUN16_GBM",      "Anaxyrus.quercicus_PA3_RUN17_GBM",     
                                                               "Anaxyrus.quercicus_PA3_RUN18_GBM",      "Anaxyrus.quercicus_PA4_RUN1_GBM",      
                                                               "Anaxyrus.quercicus_PA4_RUN2_GBM" ,      "Anaxyrus.quercicus_PA4_RUN8_GBM",      
                                                               "Anaxyrus.quercicus_PA4_RUN16_GBM" ,     "Anaxyrus.quercicus_PA4_RUN17_GBM",     
                                                               "Anaxyrus.quercicus_PA4_RUN18_GBM",      "Anaxyrus.quercicus_PA5_RUN1_GBM",      
                                                               "Anaxyrus.quercicus_PA5_RUN2_GBM" ,      "Anaxyrus.quercicus_PA5_RUN8_GBM",      
                                                               "Anaxyrus.quercicus_PA5_RUN16_GBM",      "Anaxyrus.quercicus_PA5_RUN17_GBM",     
                                                               "Anaxyrus.quercicus_PA5_RUN18_GBM",      "Anaxyrus.quercicus_PA6_RUN1_GBM",      
                                                               "Anaxyrus.quercicus_PA6_RUN2_GBM" ,      "Anaxyrus.quercicus_PA6_RUN8_GBM",      
                                                               "Anaxyrus.quercicus_PA6_RUN16_GBM" ,     "Anaxyrus.quercicus_PA6_RUN17_GBM",     
                                                               "Anaxyrus.quercicus_PA6_RUN18_GBM",      "Anaxyrus.quercicus_PA7_RUN1_GBM",      
                                                               "Anaxyrus.quercicus_PA7_RUN2_GBM" ,      "Anaxyrus.quercicus_PA7_RUN8_GBM",      
                                                               "Anaxyrus.quercicus_PA7_RUN16_GBM",      "Anaxyrus.quercicus_PA7_RUN17_GBM",     
                                                               "Anaxyrus.quercicus_PA7_RUN18_GBM",      "Anaxyrus.quercicus_PA8_RUN1_GBM",      
                                                               "Anaxyrus.quercicus_PA8_RUN2_GBM" ,      "Anaxyrus.quercicus_PA8_RUN8_GBM",      
                                                               "Anaxyrus.quercicus_PA8_RUN16_GBM",      "Anaxyrus.quercicus_PA8_RUN17_GBM",     
                                                               "Anaxyrus.quercicus_PA8_RUN18_GBM",      "Anaxyrus.quercicus_PA9_RUN1_GBM",      
                                                               "Anaxyrus.quercicus_PA9_RUN2_GBM" ,      "Anaxyrus.quercicus_PA9_RUN8_GBM" ,     
                                                               "Anaxyrus.quercicus_PA9_RUN16_GBM",      "Anaxyrus.quercicus_PA9_RUN17_GBM",     
                                                               "Anaxyrus.quercicus_PA9_RUN18_GBM",      "Anaxyrus.quercicus_PA10_RUN1_GBM",     
                                                               "Anaxyrus.quercicus_PA10_RUN2_GBM",      "Anaxyrus.quercicus_PA10_RUN8_GBM",     
                                                               "Anaxyrus.quercicus_PA10_RUN16_GBM",     "Anaxyrus.quercicus_PA10_RUN17_GBM",    
                                                               "Anaxyrus.quercicus_PA10_RUN18_GBM" ,    "Anaxyrus.quercicus_PA1_RUN2_XGBOOST",  
                                                               "Anaxyrus.quercicus_PA1_RUN17_XGBOOST",  "Anaxyrus.quercicus_PA1_RUN18_XGBOOST", 
                                                               "Anaxyrus.quercicus_PA2_RUN1_XGBOOST",   "Anaxyrus.quercicus_PA2_RUN2_XGBOOST",  
                                                               "Anaxyrus.quercicus_PA2_RUN8_XGBOOST",   "Anaxyrus.quercicus_PA2_RUN17_XGBOOST", 
                                                               "Anaxyrus.quercicus_PA3_RUN1_XGBOOST",   "Anaxyrus.quercicus_PA3_RUN2_XGBOOST",  
                                                               "Anaxyrus.quercicus_PA3_RUN5_XGBOOST",   "Anaxyrus.quercicus_PA3_RUN17_XGBOOST", 
                                                               "Anaxyrus.quercicus_PA3_RUN18_XGBOOST",  "Anaxyrus.quercicus_PA4_RUN1_XGBOOST",
                                                               "Anaxyrus.quercicus_PA4_RUN2_XGBOOST",   "Anaxyrus.quercicus_PA4_RUN16_XGBOOST", 
                                                               "Anaxyrus.quercicus_PA4_RUN17_XGBOOST",  "Anaxyrus.quercicus_PA4_RUN18_XGBOOST" ,
                                                               "Anaxyrus.quercicus_PA5_RUN2_XGBOOST",   "Anaxyrus.quercicus_PA5_RUN16_XGBOOST", 
                                                               "Anaxyrus.quercicus_PA5_RUN18_XGBOOST",  "Anaxyrus.quercicus_PA6_RUN1_XGBOOST",  
                                                               "Anaxyrus.quercicus_PA6_RUN2_XGBOOST",   "Anaxyrus.quercicus_PA6_RUN16_XGBOOST", 
                                                               "Anaxyrus.quercicus_PA6_RUN18_XGBOOST",  "Anaxyrus.quercicus_PA7_RUN1_XGBOOST",  
                                                               "Anaxyrus.quercicus_PA7_RUN8_XGBOOST",   "Anaxyrus.quercicus_PA7_RUN16_XGBOOST", 
                                                               "Anaxyrus.quercicus_PA7_RUN17_XGBOOST",  "Anaxyrus.quercicus_PA7_RUN18_XGBOOST", 
                                                               "Anaxyrus.quercicus_PA8_RUN1_XGBOOST",   "Anaxyrus.quercicus_PA8_RUN2_XGBOOST",  
                                                               "Anaxyrus.quercicus_PA8_RUN8_XGBOOST",   "Anaxyrus.quercicus_PA8_RUN16_XGBOOST", 
                                                               "Anaxyrus.quercicus_PA8_RUN17_XGBOOST",  "Anaxyrus.quercicus_PA8_RUN18_XGBOOST", 
                                                               "Anaxyrus.quercicus_PA9_RUN1_XGBOOST",   "Anaxyrus.quercicus_PA9_RUN2_XGBOOST",  
                                                               "Anaxyrus.quercicus_PA9_RUN8_XGBOOST",   "Anaxyrus.quercicus_PA9_RUN18_XGBOOST", 
                                                               "Anaxyrus.quercicus_PA10_RUN2_XGBOOST",  "Anaxyrus.quercicus_PA10_RUN16_XGBOOST",
                                                               "Anaxyrus.quercicus_PA10_RUN17_XGBOOST", "Anaxyrus.quercicus_PA10_RUN18_XGBOOST",
                                                               "Anaxyrus.quercicus_PA11_RUN1_GLM",      "Anaxyrus.quercicus_PA11_RUN8_GLM",     
                                                               "Anaxyrus.quercicus_PA11_RUN17_GLM",     "Anaxyrus.quercicus_PA11_RUN18_GLM"),#'all',
                                             metric.binary = 'all',
                                             metric.filter = 'all',
                                             output.format = ".img", #default is .tif --> need .img for BIOMOD_RangeSize
                                             build.clamping.mask = TRUE)
AmphiMod2100Proj_ssp370
plot(AmphiMod2100Proj_ssp370)

#load previously run output
#load("Anaxyrus.quercicus/proj_2100_ssp370/Anaxyrus.quercicus.2100_ssp370.projection.out")
## Be careful, the object within R as the same name as its filename !
## You can rename it if you prefer :
#AmphiMod2100Proj_ssp370 <- Anaxyrus.quercicus.2100_ssp370.projection.out


#Ensemble model forecasting ssp370 --> 2080-2100
AmphiMod_ensemble_2100Proj_ssp370 <- BIOMOD_EnsembleForecasting(bm.em = AmphiModelEM,
                                                                bm.proj = AmphiMod2100Proj_ssp370,
                                                                models.chosen = 'all', #use the get_built_models for possible models
                                                                metric.binary = 'all',
                                                                output.format = ".img", #default is .tif --> need .img for BIOMOD_RangeSize
                                                                metric.filter = 'all')

AmphiMod_ensemble_2100Proj_ssp370
plot(AmphiMod_ensemble_2100Proj_ssp370)

#load previously run output
load("Anaxyrus.quercicus/proj_2100_ssp370/Anaxyrus.quercicus.2100_ssp370.ensemble.projection.out")
## Be careful, the object within R as the same name as its filename !
## You can rename it if you prefer :
AmphiMod_ensemble_2100Proj_ssp370 <- Anaxyrus.quercicus.2100_ssp370.ensemble.projection.out
plot(AmphiMod_ensemble_2100Proj_ssp370)



## ssp245 ##


# Project single models ssp245 --> 2080-2100
  #Include only the kept models from the ensemble model using the models chosen argument
    #increases the speed of the BIOMOD_Projection() function

AmphiMod2100Proj_ssp245 <- BIOMOD_Projection(bm.mod = AmphiModelOut,
                                             proj.name = '2100_ssp245',
                                             new.env = bioclim2100_SE_US_sub245,
                                             models.chosen = c("Anaxyrus.quercicus_PA1_RUN1_GBM",       "Anaxyrus.quercicus_PA1_RUN2_GBM",      
                                                               "Anaxyrus.quercicus_PA1_RUN8_GBM",       "Anaxyrus.quercicus_PA1_RUN17_GBM",     
                                                               "Anaxyrus.quercicus_PA1_RUN18_GBM",      "Anaxyrus.quercicus_PA2_RUN1_GBM",      
                                                               "Anaxyrus.quercicus_PA2_RUN2_GBM" ,      "Anaxyrus.quercicus_PA2_RUN8_GBM",      
                                                               "Anaxyrus.quercicus_PA2_RUN16_GBM" ,     "Anaxyrus.quercicus_PA2_RUN17_GBM",     
                                                               "Anaxyrus.quercicus_PA2_RUN18_GBM",      "Anaxyrus.quercicus_PA3_RUN1_GBM",      
                                                               "Anaxyrus.quercicus_PA3_RUN2_GBM",       "Anaxyrus.quercicus_PA3_RUN8_GBM",      
                                                               "Anaxyrus.quercicus_PA3_RUN16_GBM",      "Anaxyrus.quercicus_PA3_RUN17_GBM",     
                                                               "Anaxyrus.quercicus_PA3_RUN18_GBM",      "Anaxyrus.quercicus_PA4_RUN1_GBM",      
                                                               "Anaxyrus.quercicus_PA4_RUN2_GBM" ,      "Anaxyrus.quercicus_PA4_RUN8_GBM",      
                                                               "Anaxyrus.quercicus_PA4_RUN16_GBM" ,     "Anaxyrus.quercicus_PA4_RUN17_GBM",     
                                                               "Anaxyrus.quercicus_PA4_RUN18_GBM",      "Anaxyrus.quercicus_PA5_RUN1_GBM",      
                                                               "Anaxyrus.quercicus_PA5_RUN2_GBM" ,      "Anaxyrus.quercicus_PA5_RUN8_GBM",      
                                                               "Anaxyrus.quercicus_PA5_RUN16_GBM",      "Anaxyrus.quercicus_PA5_RUN17_GBM",     
                                                               "Anaxyrus.quercicus_PA5_RUN18_GBM",      "Anaxyrus.quercicus_PA6_RUN1_GBM",      
                                                               "Anaxyrus.quercicus_PA6_RUN2_GBM" ,      "Anaxyrus.quercicus_PA6_RUN8_GBM",      
                                                               "Anaxyrus.quercicus_PA6_RUN16_GBM" ,     "Anaxyrus.quercicus_PA6_RUN17_GBM",     
                                                               "Anaxyrus.quercicus_PA6_RUN18_GBM",      "Anaxyrus.quercicus_PA7_RUN1_GBM",      
                                                               "Anaxyrus.quercicus_PA7_RUN2_GBM" ,      "Anaxyrus.quercicus_PA7_RUN8_GBM",      
                                                               "Anaxyrus.quercicus_PA7_RUN16_GBM",      "Anaxyrus.quercicus_PA7_RUN17_GBM",     
                                                               "Anaxyrus.quercicus_PA7_RUN18_GBM",      "Anaxyrus.quercicus_PA8_RUN1_GBM",      
                                                               "Anaxyrus.quercicus_PA8_RUN2_GBM" ,      "Anaxyrus.quercicus_PA8_RUN8_GBM",      
                                                               "Anaxyrus.quercicus_PA8_RUN16_GBM",      "Anaxyrus.quercicus_PA8_RUN17_GBM",     
                                                               "Anaxyrus.quercicus_PA8_RUN18_GBM",      "Anaxyrus.quercicus_PA9_RUN1_GBM",      
                                                               "Anaxyrus.quercicus_PA9_RUN2_GBM" ,      "Anaxyrus.quercicus_PA9_RUN8_GBM" ,     
                                                               "Anaxyrus.quercicus_PA9_RUN16_GBM",      "Anaxyrus.quercicus_PA9_RUN17_GBM",     
                                                               "Anaxyrus.quercicus_PA9_RUN18_GBM",      "Anaxyrus.quercicus_PA10_RUN1_GBM",     
                                                               "Anaxyrus.quercicus_PA10_RUN2_GBM",      "Anaxyrus.quercicus_PA10_RUN8_GBM",     
                                                               "Anaxyrus.quercicus_PA10_RUN16_GBM",     "Anaxyrus.quercicus_PA10_RUN17_GBM",    
                                                               "Anaxyrus.quercicus_PA10_RUN18_GBM" ,    "Anaxyrus.quercicus_PA1_RUN2_XGBOOST",  
                                                               "Anaxyrus.quercicus_PA1_RUN17_XGBOOST",  "Anaxyrus.quercicus_PA1_RUN18_XGBOOST", 
                                                               "Anaxyrus.quercicus_PA2_RUN1_XGBOOST",   "Anaxyrus.quercicus_PA2_RUN2_XGBOOST",  
                                                               "Anaxyrus.quercicus_PA2_RUN8_XGBOOST",   "Anaxyrus.quercicus_PA2_RUN17_XGBOOST", 
                                                               "Anaxyrus.quercicus_PA3_RUN1_XGBOOST",   "Anaxyrus.quercicus_PA3_RUN2_XGBOOST",  
                                                               "Anaxyrus.quercicus_PA3_RUN5_XGBOOST",   "Anaxyrus.quercicus_PA3_RUN17_XGBOOST", 
                                                               "Anaxyrus.quercicus_PA3_RUN18_XGBOOST",  "Anaxyrus.quercicus_PA4_RUN1_XGBOOST",
                                                               "Anaxyrus.quercicus_PA4_RUN2_XGBOOST",   "Anaxyrus.quercicus_PA4_RUN16_XGBOOST", 
                                                               "Anaxyrus.quercicus_PA4_RUN17_XGBOOST",  "Anaxyrus.quercicus_PA4_RUN18_XGBOOST" ,
                                                               "Anaxyrus.quercicus_PA5_RUN2_XGBOOST",   "Anaxyrus.quercicus_PA5_RUN16_XGBOOST", 
                                                               "Anaxyrus.quercicus_PA5_RUN18_XGBOOST",  "Anaxyrus.quercicus_PA6_RUN1_XGBOOST",  
                                                               "Anaxyrus.quercicus_PA6_RUN2_XGBOOST",   "Anaxyrus.quercicus_PA6_RUN16_XGBOOST", 
                                                               "Anaxyrus.quercicus_PA6_RUN18_XGBOOST",  "Anaxyrus.quercicus_PA7_RUN1_XGBOOST",  
                                                               "Anaxyrus.quercicus_PA7_RUN8_XGBOOST",   "Anaxyrus.quercicus_PA7_RUN16_XGBOOST", 
                                                               "Anaxyrus.quercicus_PA7_RUN17_XGBOOST",  "Anaxyrus.quercicus_PA7_RUN18_XGBOOST", 
                                                               "Anaxyrus.quercicus_PA8_RUN1_XGBOOST",   "Anaxyrus.quercicus_PA8_RUN2_XGBOOST",  
                                                               "Anaxyrus.quercicus_PA8_RUN8_XGBOOST",   "Anaxyrus.quercicus_PA8_RUN16_XGBOOST", 
                                                               "Anaxyrus.quercicus_PA8_RUN17_XGBOOST",  "Anaxyrus.quercicus_PA8_RUN18_XGBOOST", 
                                                               "Anaxyrus.quercicus_PA9_RUN1_XGBOOST",   "Anaxyrus.quercicus_PA9_RUN2_XGBOOST",  
                                                               "Anaxyrus.quercicus_PA9_RUN8_XGBOOST",   "Anaxyrus.quercicus_PA9_RUN18_XGBOOST", 
                                                               "Anaxyrus.quercicus_PA10_RUN2_XGBOOST",  "Anaxyrus.quercicus_PA10_RUN16_XGBOOST",
                                                               "Anaxyrus.quercicus_PA10_RUN17_XGBOOST", "Anaxyrus.quercicus_PA10_RUN18_XGBOOST",
                                                               "Anaxyrus.quercicus_PA11_RUN1_GLM",      "Anaxyrus.quercicus_PA11_RUN8_GLM",     
                                                               "Anaxyrus.quercicus_PA11_RUN17_GLM",     "Anaxyrus.quercicus_PA11_RUN18_GLM"),#'all',
                                             metric.binary = 'all',
                                             metric.filter = 'all',
                                             output.format = ".img", #default is .tif --> need .img for BIOMOD_RangeSize
                                             build.clamping.mask = TRUE)
AmphiMod2100Proj_ssp245
#plot(AmphiMod2100Proj_ssp245)

#load previously run output
#load("Anaxyrus.quercicus/proj_2100_ssp245/Anaxyrus.quercicus.2100_ssp245.projection.out")
## Be careful, the object within R as the same name as its filename !
## You can rename it if you prefer :
#AmphiMod2100Proj_ssp245 <- Anaxyrus.quercicus.2100_ssp245.projection.out


#Ensemble model forecasting ssp245 --> 2080-2100
AmphiMod_ensemble_2100Proj_ssp245 <- BIOMOD_EnsembleForecasting(bm.em = AmphiModelEM,
                                                                bm.proj = AmphiMod2100Proj_ssp245,
                                                                models.chosen = 'all', #use the get_built_models for possible models
                                                                metric.binary = 'all',
                                                                output.format = ".img", #default is .tif --> need .img for BIOMOD_RangeSize
                                                                metric.filter = 'all')

AmphiMod_ensemble_2100Proj_ssp245
plot(AmphiMod_ensemble_2100Proj_ssp245)

#load previously run output
load("Anaxyrus.quercicus/proj_2100_ssp245/Anaxyrus.quercicus.2100_ssp245.ensemble.projection.out")
## Be careful, the object within R as the same name as its filename !
## You can rename it if you prefer :
AmphiMod_ensemble_2100Proj_ssp245 <- Anaxyrus.quercicus.2100_ssp245.ensemble.projection.out
plot(AmphiMod_ensemble_2100Proj_ssp245)



## Plotting range and projection data together -- 


#Anaxyrus quercicus range shp file
library(sf)
setwd("E:/SDM/ArcGISPro/DataFiles/SpeciesDistributionLayers/Anaxyrus_quercicus")
Anaxyrus_quercicus_range <- st_read("Anaxyrus_quercicus.shp")
plot(Anaxyrus_quercicus_range$geometry) #plots data for visualization
st_geometry_type(Anaxyrus_quercicus_range) #indicates geometry of sf object
st_crs(Anaxyrus_quercicus_range) #check coordinate reference system
summary(Anaxyrus_quercicus_range) #summaries metadata


#US States shape file
setwd("E:/SDM/ArcGISPro/DataFiles/US_States_Shp/cb_2018_us_state_20m")
US_States_SF <- st_read("cb_2018_us_state_20m.shp")
plot(US_States_SF$geometry) #plots data for visualization


#set working directory to output folder
setwd("E:/SDM/SDM/output")

#convert lat/long into SF point object
Amphi_occSF = st_as_sf(Amphi_occ, coords = c("longitude","latitude"), remove = FALSE)

#Update observation data coordinate system to match the range shapefile
st_crs(Amphi_occSF) #no coordinate system specified
AnaxQue_occSF_Map <- Amphi_occSF %>% st_set_crs(st_crs(Anaxyrus_quercicus_range)) 
#make coordinate system the same as range shapefile
st_crs(AnaxQue_occSF_Map) #check that the coordinate system was changed


#Amphi range plotted
(AmphiMap <- ggplot(data = Anaxyrus_quercicus_range) +
    geom_sf(fill = "NA"))
AmphiMap

#Amphi obs plotted
(AmphiMap2 <- ggplot(data = Amphi_occSF) +
    geom_sf(fill = "NA"))
AmphiMap2

#combine Amphi range and obs
AmphiMap3 <- ggplot() +
  #---US States shp ---#
  geom_sf(data = US_States_SF) +
  #--- Anaxyrus quercicus range ---#
  geom_sf(data = Anaxyrus_quercicus_range, fill = "yellow") + #change range for each species
  #--- Anaxyrus quercicus iNaturalist Obs ---#
  geom_sf(data = AnaxQue_occSF_Map, fill = "NA")+
  ggtitle("Anaxyrus quercicus Occupancy")+
  xlim(-95, -65) +
  ylim(25, 50)
AmphiMap3



#Load projection rasters for mapping -- 


#Load ensemble forecasting projection raster output --> current climate
setwd("E:/SDM/SDM/Output/Anaxyrus.quercicus/proj_Current")
#ensemble <- raster("proj_Current_Anaxyrus.quercicus_ensemble.tif") #only need this raster file to make the plot/use if default
ensemble <- stack("proj_Current_Anaxyrus.quercicus_ensemble.img") #use if exporting as a .img

#Load ensemble forecasting projection raster output --> 2100 climate
setwd("E:/SDM/SDM/Output/Anaxyrus.quercicus/proj_2100_ssp585")
#ensemble2100_ssp585 <- raster("proj_2100_ssp585_Anaxyrus.quercicus_ensemble.tif") #use if default
ensemble2100_ssp585 <- stack("proj_2100_ssp585_Anaxyrus.quercicus_ensemble.img") #use if exporting as a .img

#Load ensemble forecasting projection raster output --> 2100 climate
setwd("E:/SDM/SDM/Output/Anaxyrus.quercicus/proj_2100_ssp370")
#ensemble2100_ssp370 <- raster("proj_2100_ssp370_Anaxyrus.quercicus_ensemble.tif") #use if default
ensemble2100_ssp370 <- stack("proj_2100_ssp370_Anaxyrus.quercicus_ensemble.img") #use if exporting as a .img

#Load ensemble forecasting projection raster output --> 2100 climate
setwd("E:/SDM/SDM/Output/Anaxyrus.quercicus/proj_2100_ssp245")
#ensemble2100_ssp245 <- raster("proj_2100_ssp245_Anaxyrus.quercicus_ensemble.tif") #use if default 
ensemble2100_ssp245 <- stack("proj_2100_ssp245_Anaxyrus.quercicus_ensemble.img") #use if exporting as a .img



#Format the rasters for mapping --

#set working directory to output folder
setwd("E:/SDM/SDM/output")

#current projection --
#convert the raster tif into a df so it can be plotted --> current climate
ensemble_df <-
  as.data.frame(ensemble, xy = TRUE) %>%
  #--- remove cells with NA for any of the layers ---#
  na.omit() #%>%
#--- change the variable names ---#
colnames(ensemble_df) <- c('x','y','value')
head(ensemble_df) #check df

#ssp 585 -- 
#convert the raster tif into a df so it can be plotted --> 2100 climate
ensemble2100_ssp585_df <-
  as.data.frame(ensemble2100_ssp585, xy = TRUE) %>%
  #--- remove cells with NA for any of the layers ---#
  na.omit() #%>%
#--- change the variable names ---#
colnames(ensemble2100_ssp585_df) <- c('x','y','value')
head(ensemble2100_ssp585_df) #check df

#ssp 370 -- 
#convert the raster tif into a df so it can be plotted --> 2100 climate
ensemble2100_ssp370_df <-
  as.data.frame(ensemble2100_ssp370, xy = TRUE) %>%
  #--- remove cells with NA for any of the layers ---#
  na.omit() #%>%
#--- change the variable names ---#
colnames(ensemble2100_ssp370_df) <- c('x','y','value')
head(ensemble2100_ssp370_df) #check df

#ssp 245 -- 
#convert the raster tif into a df so it can be plotted --> 2100 climate
ensemble2100_ssp245_df <-
  as.data.frame(ensemble2100_ssp245, xy = TRUE) %>%
  #--- remove cells with NA for any of the layers ---#
  na.omit() #%>%
#--- change the variable names ---#
colnames(ensemble2100_ssp245_df) <- c('x','y','value')
head(ensemble2100_ssp245_df) #check df


#plot ensemble forecasting projection raster 
ensemble_map <- ggplot(data = ensemble_df) +
  geom_raster(aes(x = x, y = y, fill = `value`)) +
  scale_fill_viridis_c() +
  theme_void() +
  theme(
    legend.position = "bottom"
  )
ensemble_map



#Plot current and future projections and compare with current range -- 

#plot ensemble raster and Amphi range on map -- current climate
AmphiMapCurrent <- ggplot() +
  geom_raster(data = ensemble_df, aes(x = x, y = y, fill = `value`)) + #include ensemble raster
  geom_sf(data = Anaxyrus_quercicus_range, fill = NA, color = "darkorange",linewidth  = 1) + #include and format species range
  scale_fill_viridis_c() +
  theme_void() +
  theme(legend.position = "bottom")
AmphiMapCurrent

#plot ensemble raster and Amphi range on map -- ssp 585 -> 2080-2100 climate
AmphiMap2100_ssp585 <- ggplot() +
  geom_raster(data = ensemble2100_ssp585_df, aes(x = x, y = y, fill = `value`)) + #include ensemble raster
  geom_sf(data = Anaxyrus_quercicus_range, fill = NA, color = "darkorange",linewidth  = 1) + #include and format species range
  scale_fill_viridis_c() +
  theme_void() +
  theme(legend.position = "bottom")
AmphiMap2100_ssp585

#plot ensemble raster and Amphi range on map -- ssp 370 -> 2080-2100 climate
AmphiMap2100_ssp370 <- ggplot() +
  geom_raster(data = ensemble2100_ssp370_df, aes(x = x, y = y, fill = `value`)) + #include ensemble raster
  geom_sf(data = Anaxyrus_quercicus_range, fill = NA, color = "darkorange",linewidth  = 1) + #include and format species range
  scale_fill_viridis_c() +
  theme_void() +
  theme(legend.position = "bottom")
AmphiMap2100_ssp370

#plot ensemble raster and Amphi range on map -- ssp 245 -> 2080-2100 climate
AmphiMap2100_ssp245 <- ggplot() +
  geom_raster(data = ensemble2100_ssp245_df, aes(x = x, y = y, fill = `value`)) + #include ensemble raster
  geom_sf(data = Anaxyrus_quercicus_range, fill = NA, color = "darkorange",linewidth  = 1) + #include and format species range
  scale_fill_viridis_c() +
  theme_void() +
  theme(legend.position = "bottom")
AmphiMap2100_ssp245



## Compare current and future projections -- 


#current
setwd("E:/SDM/SDM/Output/Anaxyrus.quercicus/proj_Current")
Amphi_bin_current_proj <- stack(c("proj_Current_Anaxyrus.quercicus_ensemble_TSSbin.img"))

#2080-2100 ssp585
setwd("E:/SDM/SDM/Output/Anaxyrus.quercicus/proj_2100_ssp585")
Amphi_bin_2100ssp585_proj <- stack(c("proj_2100_ssp585_Anaxyrus.quercicus_ensemble_TSSbin.img"))

#2080-2100 ssp370
setwd("E:/SDM/SDM/Output/Anaxyrus.quercicus/proj_2100_ssp370")
Amphi_bin_2100ssp370_proj <- stack(c("proj_2100_ssp370_Anaxyrus.quercicus_ensemble_TSSbin.img"))

#2080-2100 ssp245
setwd("E:/SDM/SDM/Output/Anaxyrus.quercicus/proj_2100_ssp245")
Amphi_bin_2100ssp245_proj <- stack(c("proj_2100_ssp245_Anaxyrus.quercicus_ensemble_TSSbin.img"))



#set working directory to output folder
setwd("E:/SDM/SDM/output")



#ssp585 -- 

#compares the plots of ensemble projection output
AmphiRangeSize <- BIOMOD_RangeSize(Amphi_bin_current_proj, Amphi_bin_2100ssp585_proj)
AmphiRangeSize

#Provides a df of the stats associated with the comparison
AmphiRangeSize$Compt.By.Models

#Paste results below




#plot the range difference
plot(AmphiRangeSize$Diff.By.Pixel)

#Key for the values
# -2 : predicted to be lost
# -1 : predicted to remain occupied
# 0 : predicted to remain unoccupied
# 1 : predicted to be gained


#Export the Range Difference output as a raster
writeRaster(AmphiRangeSize$Diff.By.Pixel, "CurrentVersus_ssp585.tif")


#Continuous raster comparison -> change in value from current to ssp585 projection
CurrentVssp585 <- stack(ensemble,ensemble2100_ssp585)
RasterCalc <- function(x) {(x[2]-x[1])}
AmphiRangeSizeCont_ssp585 <- calc(CurrentVssp585, RasterCalc)
plot(AmphiRangeSizeCont_ssp585)
writeRaster(AmphiRangeSizeCont_ssp585, "CurrentVersus_ssp585_Cont.tif")


#ssp 370 -- 

#compares the plots of ensemble projection output 
AmphiRangeSize <- BIOMOD_RangeSize(Amphi_bin_current_proj, Amphi_bin_2100ssp370_proj)
AmphiRangeSize

#Provides a df of the stats associated with the comparison
AmphiRangeSize$Compt.By.Models


#Paste results below




#plot the range difference
plot(AmphiRangeSize$Diff.By.Pixel)

#Key for the values
# -2 : predicted to be lost
# -1 : predicted to remain occupied
# 0 : predicted to remain unoccupied
# 1 : predicted to be gained


#Export the Range Difference output as a raster
writeRaster(AmphiRangeSize$Diff.By.Pixel, "CurrentVersus_ssp370.tif")

#Continuous raster comparison -> change in value from current to ssp370 projection
CurrentVssp370 <- stack(ensemble,ensemble2100_ssp370)
RasterCalc <- function(x) {(x[2]-x[1])}
AmphiRangeSizeCont_ssp370 <- calc(CurrentVssp370, RasterCalc)
plot(AmphiRangeSizeCont_ssp370)
writeRaster(AmphiRangeSizeCont_ssp370, "CurrentVersus_ssp370_Cont.tif")


#ssp 245 -- 
#compares the plots of ensemble projection output 
AmphiRangeSize <- BIOMOD_RangeSize(Amphi_bin_current_proj, Amphi_bin_2100ssp245_proj)
AmphiRangeSize

#Provides a df of the stats associated with the comparison
AmphiRangeSize$Compt.By.Models

#Paste results below




#plot the range difference
plot(AmphiRangeSize$Diff.By.Pixel)

#Key for the values
# -2 : predicted to be lost
# -1 : predicted to remain occupied
# 0 : predicted to remain unoccupied
# 1 : predicted to be gained


#Export the Range Difference output as a raster
writeRaster(AmphiRangeSize$Diff.By.Pixel, "CurrentVersus_ssp245.tif")

#Continuous raster comparison -> change in value from current to ssp245 projection
CurrentVssp245 <- stack(ensemble,ensemble2100_ssp245)
RasterCalc <- function(x) {(x[2]-x[1])}
AmphiRangeSizeCont_ssp245 <- calc(CurrentVssp245, RasterCalc)
plot(AmphiRangeSizeCont_ssp245)
writeRaster(AmphiRangeSizeCont_ssp245, "CurrentVersus_ssp245_Cont.tif")


#Histograms for raster values from projections -- 

#current

CurrentProjHist <- hist(ensemble,
                   main = "Distribution of SDM Values",
                   xlab = "Raster value", ylab = "Frequency",
                   ylim = c(0,10000),
                   col = "springgreen")

CurrentProjHist

#ssp585

ssp585ProjHist <- hist(ensemble2100_ssp585,
                    main = "ssp 585 Distribution of SDM Values",
                    xlab = "Raster value", ylab = "Frequency",
                    ylim = c(0,10000),
                    col = "springgreen")

ssp585ProjHist

#ssp370

ssp370ProjHist <- hist(ensemble2100_ssp370,
                    main = "ssp 370 Distribution of SDM Values",
                    xlab = "Raster value", ylab = "Frequency",
                    ylim = c(0,10000),
                    col = "springgreen")

ssp370ProjHist

#ssp245

ssp245ProjHist <- hist(ensemble2100_ssp245,
                    main = "ssp 245 Distribution of SDM Values",
                    xlab = "Raster value", ylab = "Frequency",
                    ylim = c(0,10000),
                    col = "springgreen")

ssp245ProjHist

#End of SDM script


