#   Analysis of UBWOS surface met sites
require(date)
source("/home/grc/AMET_Dev/R_analysis_code/MET_amet.stats-lib.R")
source("/home/grc/AMET_Dev/R_analysis_code/MET_amet.misc-lib.R")
# FantasyCanyon_TA_RH_PS_WD_WS_BaseCase.csv
# date,          obs_temp,  model_temp, obs_pressure, model_pressure,  obs_rh,  model_rh,    obs_wd, model_wd,    obs_ws,   model_ws
# MM/DD/YYYY_HH, deg_C,          deg_C,           mb,             mb,  percent,   percent,  degrees,  degrees, meter/sec,   meters/sec

# Fruitland_TA_WD_WS_BaseCase.csv
# date,          obs_temp,    model_temp,  obs_wd,  model_wd, obs_ws,      model_ws
# MM/DD/YYYY_HH,     degC,          degC, degrees,   degrees, meter/sec, meters/sec

	dates   <- ISOdatetime(year=2013, month=2, day=1,  hour=0, min=0, sec=0, tz="LT")
	datee   <- ISOdatetime(year=2013, month=2, day=10,  hour=0, min=0, sec=0, tz="LT")
  date.vec<-seq(dates,datee,by="hour")

sitefmt<-c(2,2,2)
sites  <-c("Horsepool","Ouray","FantasyCanyon")
files  <-c("Horsepool_TA_RH_PS_WD_WS_BaseCase.csv","Ouray_TA_RH_PS_WD_WS_BaseCase.csv","FantasyCanyon_TA_RH_PS_WD_WS_BaseCase.csv")

sitefmt<-c(1,1,1,1,1,1,1,1)
sites  <-c("Fruitland","Myton","RabbitMtn","Rangely","RedWash","Roosevelt","Vernal")
files  <-c("Fruitland_TA_WD_WS_BaseCase.csv","Myton_TA_WD_WS_BaseCase.csv",
          "RabbitMtn_TA_WD_WS_BaseCase.csv","Rangely_TA_WD_WS_BaseCase.csv","RedWash_TA_WD_WS_BaseCase.csv",
          "Roosevelt_TA_WD_WS_BaseCase.csv","Vernal_TA_WD_WS_BaseCase.csv")

nf<-length(files)
T <-array(NA,c(length(date.vec),2,nf))
RH<-array(NA,c(length(date.vec),2,nf))
WS<-array(NA,c(length(date.vec),2,nf))
WD<-array(NA,c(length(date.vec),2,nf))
UU<-array(NA,c(length(date.vec),2,nf))
VV<-array(NA,c(length(date.vec),2,nf))

###################################################################################
for(f in 1:nf){

if(sitefmt[f] ==1) {
 Tind <-c(2,3)
 WSind<-c(6,7)
 WDind<-c(4,5)
 RHind<-c(NA,NA)
}
if(sitefmt[f] ==2) {
 Tind <-c(2,3)
 WSind<-c(10,11)
 WDind<-c(8,9)
 RHind<-c(6,7)
}

rdin<-read.csv(files[f],skip=1)
nlines<-dim(rdin)[1]
for(l in 1:nlines){
  wrd1 <-unlist(strsplit(as.character(rdin[l,1]),"/"))
  wrd2 <-as.numeric(unlist(strsplit(wrd1[3],"_")))
  year <-wrd2[1]
  hour <-wrd2[2]
  month<-as.numeric(wrd1[1])
  day  <-as.numeric(wrd1[2])
  if(wrd2[2] == 24) {
   day <-day+1
   hour<-0
  } 
  cdate<-ISOdatetime(year=year, month=month, day=day,  hour=hour, min=0, sec=0, tz="LT")
  if(cdate > datee) { next }
  ind<-which(cdate == date.vec)
   T[ind,,f]<-as.numeric(rdin[l,Tind[1]:Tind[2]])+273.14
  WS[ind,,f]<-as.numeric(rdin[l,WSind[1]:WSind[2]])
  WD[ind,,f]<-as.numeric(rdin[l,WDind[1]:WDind[2]])
  if(sitefmt[f] == 2){
    RH[ind,,f]<-as.numeric(rdin[l,RHind[1]:RHind[2]])
  } 
  writeLines(paste("Date/hour:",cdate, as.character(rdin[l,1])))
}  
}
# Clean arrays by setting missing data to NA
T  <-ifelse(T < 0, NA, T)
WS <-ifelse(WS == -999,NA,WS)
WD <-ifelse(WD == -999,NA,WD)
RH <-ifelse(RH == -999,NA,RH)

UU <-(-1)*WS*sin(WD*pi/180)
VV <-(-1)*WS*cos(WD*pi/180)

diff<-WD[,2,]-WD[,1,]
diff<-ifelse(diff > 180 , diff-360, diff)
diff<-ifelse(diff< -180 , diff+360, diff)
#dir = 180+(360/(2*pi))*atan2(UU,VV)
###################################################################################
###################################################################################
## Compute average meteorology at each time over all sites
Tavg <-array(NA,c(length(date.vec),2))
WSavg<-array(NA,c(length(date.vec),2))
WDavg<-array(NA,c(length(date.vec),2))
UUavg<-array(NA,c(length(date.vec),2))
VVavg<-array(NA,c(length(date.vec),2))
DFavg<-array(0.0,c(length(date.vec),2))
# Compute timeseries average Model and Obs
for(tt in 1:length(date.vec)){

  Tavg[tt,1] <-mean(T[tt,1,],na.rm=TRUE)
  Tavg[tt,2] <-mean(T[tt,2,],na.rm=TRUE)
  if(is.nan(Tavg[tt,1]) || is.nan(Tavg[tt,2]) ){
    Tavg[tt,1] <-NA
    Tavg[tt,2] <-NA
  } 

  WSavg[tt,1] <-mean(WS[tt,1,],na.rm=TRUE)
  WSavg[tt,2] <-mean(WS[tt,2,],na.rm=TRUE)
  if(is.nan(WSavg[tt,1]) || is.nan(WSavg[tt,2]) ){
    WSavg[tt,1] <-NA
    WSavg[tt,2] <-NA
  }

  UUavg[tt,1] <-mean(UU[tt,1,],na.rm=TRUE)
  UUavg[tt,2] <-mean(UU[tt,2,],na.rm=TRUE)
  VVavg[tt,1] <-mean(VV[tt,1,],na.rm=TRUE)
  VVavg[tt,2] <-mean(VV[tt,2,],na.rm=TRUE)
  if(is.nan(UUavg[tt,1]) || is.nan(UUavg[tt,2]) ){
    UUavg[tt,1] <-NA
    UUavg[tt,2] <-NA
    VVavg[tt,1] <-NA
    VVavg[tt,2] <-NA
  }
  WDavg[tt,1]<-180+(360/(2*pi))*atan2(UUavg[tt,1],VVavg[tt,1])
  WDavg[tt,2]<-180+(360/(2*pi))*atan2(UUavg[tt,2],VVavg[tt,2])
  DFavg[tt,2]<-mean(diff[tt,],na.rm=TRUE)
}
###################################################################################
###################################################################################
###################################################################################
## Compute statistics at each site
stats <-array(NA,c(nf,3,3))

for(f in 1:nf){

obs<-T[,1,f]
mod<-T[,2,f]
stats[f,1,1]<-sprintf("%.2f",mbias(obs,mod,na.rm=TRUE))
stats[f,1,2]<-sprintf("%.2f",rmserror(obs,mod,na.rm=TRUE))
stats[f,1,3]<-sprintf("%.2f",ac(obs,mod))

obs<-WS[,1,f]
mod<-WS[,2,f]
stats[f,2,1]<-sprintf("%.2f",mbias(obs,mod,na.rm=TRUE))
stats[f,2,2]<-sprintf("%.2f",rmserror(obs,mod,na.rm=TRUE))
stats[f,2,3]<-sprintf("%.2f",ac(obs,mod))

obs<-diff[,f]
mod<-obs*0.0
stats[f,3,1]<-sprintf("%.2f",mbias(obs,mod,na.rm=TRUE))
stats[f,3,2]<-sprintf("%.2f",rmserror(obs,mod,na.rm=TRUE))

}
###################################################################################

###########################
# Offical plots for Paper
###########################
# Temperature
bias<-sprintf("%.2f",mbias(Tavg[,1],Tavg[,2],na.rm=TRUE))
rmse<-sprintf("%.2f",rmserror(Tavg[,1],Tavg[,2],na.rm=TRUE))
ioa<-sprintf("%.2f",ac(Tavg[,1],Tavg[,2]))

str1<-paste("RMSE:",rmse)
str2<-paste("BIAS:",bias)
str3<-paste("IOA :",ioa)


ylimits<-c(260,276)
pdf("temp.pdf",width = 10, height = 5)
 par(new=FALSE)
 plot(date.vec,Tavg[,1],type='l',xlim=range(date.vec),ylim=ylimits,col="black",xlab="",ylab="", lwd=1.5)
 par(new=TRUE)
 plot(date.vec,Tavg[,2],type='l',xlim=range(date.vec),ylim=ylimits,col="red",xlab="Date",ylab="2-m Temperature (K)", lwd=1.5)
 legend("bottomleft",c("Obs Avg","WRF Avg"),text.col=c("black","red"),cex=1.0, bg="white")     
 legend("topright",c(paste(str1," -- ",str2," -- ",str3)),text.col=c("black"),cex=1.15, bg="white")     
 legend("topleft",c("(a)"),text.col=c("black"),cex=1.75,xjust=0.5,yjust=0.5, box.col = NA)     
dev.off()

# Wind Speed 
bias<-sprintf("%.2f",mbias(WSavg[,1],WSavg[,2],na.rm=TRUE))
rmse<-sprintf("%.2f",rmserror(WSavg[,1],WSavg[,2],na.rm=TRUE))
ioa<-sprintf("%.2f",ac(WSavg[,1],WSavg[,2]))

str1<-paste("RMSE:",rmse)
str2<-paste("BIAS:",bias)
str3<-paste("IOA :",ioa)


ylimits<-c(0,4)
pdf("ws.pdf",width = 10, height = 5)
 par(new=FALSE)
 plot(date.vec,WSavg[,1],type='l',xlim=range(date.vec),ylim=ylimits,col="black",xlab="",ylab="", lwd=1.5)
 par(new=TRUE)
 plot(date.vec,WSavg[,2],type='l',xlim=range(date.vec),ylim=ylimits,col="red",xlab="Date",ylab="10-m Wind Speed (m/s)", lwd=1.5)
 legend("bottomleft",c("Obs Avg","WRF Avg"),text.col=c("black","red"),cex=1.0, bg="white")     
 legend("topright",c(paste(str1," -- ",str2," -- ",str3)),text.col=c("black"),cex=1.15, bg="white")     
 legend("topleft",c("(b)"),text.col=c("black"),cex=1.75,xjust=0.5,yjust=0.5, box.col = NA)     
dev.off()

# Wind Direction
bias<-sprintf("%.0f",mbias(DFavg[,1],DFavg[,2],na.rm=TRUE))
rmse<-sprintf("%.0f",rmserror(DFavg[,1],DFavg[,2],na.rm=TRUE))
ioa<-"NA"

str1<-paste("RMSE:",rmse)
str2<-paste("BIAS:",bias)
str3<-paste("IOA :",ioa)


ylimits<-c(0,360)
pdf("wd.pdf",width = 10, height = 5)
 par(new=FALSE)
 plot(date.vec,WDavg[,1],type='p',xlim=range(date.vec),ylim=ylimits,col="black",xlab="",ylab="", lwd=1.5)
 par(new=TRUE)
 plot(date.vec,WDavg[,2],type='p',xlim=range(date.vec),ylim=ylimits,col="red",xlab="Date",ylab="10-m Wind Direction (deg)", lwd=1.5)
 legend("bottomleft",c("Obs Avg","WRF Avg"),text.col=c("black","red"),cex=1.0, bg="white")     
 legend("topright",c(paste(str1," -- ",str2," -- ",str3)),text.col=c("black"),cex=1.15, bg="white")     
 legend("topleft",c("(c)"),text.col=c("black"),cex=1.75,xjust=0.5,yjust=0.5, box.col = NA)     
dev.off()
###########################
Omean<-a1*NA
Mmean<-a1*NA

for(tt in 1:10){
Omean[tt]<-mean(c(a1[tt],b1[tt]),na.rm=TRUE)
Mmean[tt]<-mean(c(a2[tt],b2[tt]),na.rm=TRUE)
}

rmse<-sprintf("%.2f",rmserror(Omean,Mmean,na.rm=TRUE))
